/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.stemmer;

import edu.northwestern.at.morphadorner.corpuslinguistics.stemmer.DefaultStemmer;
import edu.northwestern.at.morphadorner.corpuslinguistics.stemmer.Stemmer;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class StemmerFactory {
    public static Stemmer newStemmer() {
        String className = System.getProperty("stemmer.class");
        if (className == null) {
            className = "DefaultStemmer";
        }
        return StemmerFactory.newStemmer(className);
    }

    public static Stemmer newStemmer(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("stemmer.class");
        }
        if (className == null) {
            className = "DefaultStemmer";
        }
        return StemmerFactory.newStemmer(className);
    }

    public static Stemmer newStemmer(String className) {
        Stemmer stemmer = null;
        try {
            stemmer = (Stemmer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(StemmerFactory.class.getName()) + "." + className;
            try {
                stemmer = (Stemmer)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create stemmer of class " + fixedClassName + ", using default.");
                try {
                    stemmer = new DefaultStemmer();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return stemmer;
    }
}

