/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.stemmer;

import edu.northwestern.at.morphadorner.corpuslinguistics.stemmer.Stemmer;
import edu.northwestern.at.utils.CharUtils;
import java.util.Vector;

public class LancasterStemmer
implements Stemmer {
    public static final String[] prefixes = new String[]{"intra", "kilo", "mega", "micro", "milli", "nano", "pico", "pseudo", "ultra"};
    public static final String[] defaultStemmingRules = new String[]{"ai*2.     { -ia > -   if intact }", "a*1.      { -a > -    if intact }", "bb1.      { -bb > -b   }", "city3s.   { -ytic > -ys }", "ci2>      { -ic > -    }", "cn1t>     { -nc > -nt  }", "dd1.      { -dd > -d   }", "dei3y>    { -ied > -y  }", "deec2ss.  { -ceed > -cess }", "dee1.     { -eed > -ee }", "de2>      { -ed > -    }", "dooh4>    { -hood > -  }", "e1>       { -e > -     }", "feil1v.   { -lief > -liev }", "fi2>      { -if > -    }", "gni3>     { -ing > -   }", "gai3y.    { -iag > -y  }", "ga2>      { -ag > -    }", "gg1.      { -gg > -g   }", "ht*2.     { -th > -   if intact }", "hsiug5ct. { -guish > -ct }", "hsi3>     { -ish > -   }", "i*1.      { -i > -    if intact }", "i1y>      { -i > -y    }", "ji1d.     { -ij > -id   --  see nois4j> & vis3j> }", "juf1s.    { -fuj > -fus }", "ju1d.     { -uj > -ud  }", "jo1d.     { -oj > -od  }", "jeh1r.    { -hej > -her }", "jrev1t.   { -verj > -vert }", "jsim2t.   { -misj > -mit }", "jn1d.     { -nj > -nd  }", "j1s.      { -j > -s    }", "lbaifi6.  { -ifiabl > - }", "lbai4y.   { -iabl > -y }", "lba3>     { -abl > -   }", "lbi3.     { -ibl > -   }", "lib2l>    { -bil > -bl }", "lc1.      { -cl > c    }", "lufi4y.   { -iful > -y }", "luf3>     { -ful > -   }", "lu2.      { -ul > -    }", "lai3>     { -ial > -   }", "lau3>     { -ual > -   }", "la2>      { -al > -    }", "ll1.      { -ll > -l   }", "mui3.     { -ium > -   }", "mu*2.     { -um > -   if intact }", "msi3>     { -ism > -   }", "mm1.      { -mm > -m   }", "nois4j>   { -sion > -j }", "noix4ct.  { -xion > -ct }", "noi3>     { -ion > -   }", "nai3>     { -ian > -   }", "na2>      { -an > -    }", "nee0.     { protect  -een }", "ne2>      { -en > -    }", "nn1.      { -nn > -n   }", "pihs4>    { -ship > -  }", "pp1.      { -pp > -p   }", "re2>      { -er > -    }", "rae0.     { protect  -ear }", "ra2.      { -ar > -    }", "ro2>      { -or > -    }", "ru2>      { -ur > -    }", "rr1.      { -rr > -r   }", "rt1>      { -tr > -t   }", "rei3y>    { -ier > -y  }", "sei3y>    { -ies > -y  }", "sis2.     { -sis > -s  }", "si2>      { -is > -    }", "ssen4>    { -ness > -  }", "ss0.      { protect  -ss }", "suo3>     { -ous > -   }", "su*2.     { -us > -   if intact }", "s*1>      { -s > -    if intact }", "s0.       { -s > -s    }", "tacilp4y. { -plicat > -ply }", "ta2>      { -at > -    }", "tnem4>    { -ment > -  }", "tne3>     { -ent > -   }", "tna3>     { -ant > -   }", "tpir2b.   { -ript > -rib }", "tpro2b.   { -orpt > -orb }", "tcud1.    { -duct > -duc }", "tpmus2.   { -sumpt > -sum }", "tpec2iv.  { -cept > -ceiv }", "tulo2v.   { -olut > -olv }", "tsis0.    { protect  -sist }", "tsi3>     { -ist > -   }", "tt1.      { -tt > -t   }", "uqi3.     { -iqu > -   } ", "ugo1.     { -ogu > -og }", "vis3j>    { -siv > -j  }", "vie0.     { protect  -eiv }", "vi2>      { -iv > -    }", "ylb1>     { -bly > -bl }", "yli3y>    { -ily > -y  }", "ylp0.     { protect  -ply }", "yl2>      { -ly > -    }", "ygo1.     { -ogy > -og }", "yhp1.     { -phy > -ph }", "ymo1.     { -omy > -om }", "ypo1.     { -opy > -op }", "yti3>     { -ity > -   }", "yte3>     { -ety > -   }", "ytl2.     { -lty > -l  }", "yrtsi5.   { -istry > - }", "yra3>     { -ary > -   }", "yro3>     { -ory > -   }", "yfi3.     { -ify > -   }", "ycn2t>    { -ncy > -nt }", "yca3>     { -acy > -   }", "zi2>      { -iz > -    }", "zy1s.     { -yz > -ys  }", "end0."};
    protected static final char zeroDigit = '0';
    protected Vector<String> ruleTable;
    protected int[] ruleTableIndex;
    protected boolean preStrip;

    public LancasterStemmer() {
        this.preStrip = true;
        this.loadRules(defaultStemmingRules);
    }

    public LancasterStemmer(String[] rules) {
        this.preStrip = true;
        this.loadRules(rules);
    }

    public LancasterStemmer(String[] rules, boolean preStrip) {
        this.preStrip = preStrip;
        this.loadRules(rules);
    }

    protected void loadRules(String[] rules) {
        int i;
        this.ruleTable = new Vector();
        this.ruleTableIndex = new int[26];
        for (i = 0; i < 25; ++i) {
            this.ruleTableIndex[i] = 0;
        }
        for (i = 0; i < rules.length; ++i) {
            this.ruleTable.addElement(rules[i].replaceAll(" ", ""));
        }
        char ch = 'a';
        for (int i2 = 0; i2 < rules.length - 1; ++i2) {
            while (this.ruleTable.elementAt(i2).charAt(0) != ch) {
                ch = (char)(ch + '\u0001');
                this.ruleTableIndex[this.charCode((char)ch)] = i2;
            }
        }
    }

    protected int firstVowel(String s, int last) {
        int i;
        char prevChar = 'a';
        for (i = 0; i < last && !this.vowel(s.charAt(i), prevChar); ++i) {
            prevChar = s.charAt(i);
        }
        return Math.min(i, last);
    }

    protected String stripSuffixes(String s) {
        int ruleOK = 0;
        int done = 0;
        int lastLetterPos = 0;
        int replacedCharCount = 0;
        int firstVowelPos = 0;
        int currentRuleIndex = 0;
        int ruleCharPos = 0;
        int wordCharPos = 0;
        char lastLetter = '\u0000';
        String rule = "";
        boolean intact = true;
        String stem = this.clean(s.toLowerCase());
        lastLetterPos = 0;
        while (lastLetterPos + 1 < stem.length() && this.isLetter(stem.charAt(lastLetterPos + 1))) {
            ++lastLetterPos;
        }
        if (lastLetterPos < 1) {
            done = -1;
        } else {
            firstVowelPos = this.firstVowel(stem, lastLetterPos);
            wordCharPos = stem.length() - 1;
        }
        while (done != -1) {
            done = 0;
            lastLetter = stem.charAt(lastLetterPos);
            currentRuleIndex = this.isLetter(lastLetter) && lastLetter >= 'a' && lastLetter <= 'z' ? this.ruleTableIndex[this.charCode(lastLetter)] : -1;
            if (currentRuleIndex == -1) {
                done = -1;
                continue;
            }
            rule = this.ruleTable.elementAt(currentRuleIndex);
            while (done == 0) {
                ruleOK = 0;
                if (rule.charAt(0) != lastLetter) {
                    done = -1;
                    ruleOK = -1;
                }
                ruleCharPos = 1;
                wordCharPos = lastLetterPos - 1;
                while (ruleOK == 0) {
                    if (this.isDigit(rule.charAt(ruleCharPos))) {
                        ruleOK = 1;
                        continue;
                    }
                    if (rule.charAt(ruleCharPos) == '*') {
                        if (intact) {
                            ++ruleCharPos;
                            ruleOK = 1;
                            continue;
                        }
                        ruleOK = -1;
                        continue;
                    }
                    if (rule.charAt(ruleCharPos) != stem.charAt(wordCharPos)) {
                        ruleOK = -1;
                        continue;
                    }
                    if (wordCharPos <= firstVowelPos) {
                        ruleOK = -1;
                        continue;
                    }
                    ++ruleCharPos;
                    --wordCharPos;
                }
                if (ruleOK == 1) {
                    replacedCharCount = 0;
                    while (rule.charAt(ruleCharPos + replacedCharCount + 1) < '.' || rule.charAt(ruleCharPos + replacedCharCount + 1) > '>') {
                        ++replacedCharCount;
                    }
                    replacedCharCount = lastLetterPos + replacedCharCount + 48 - rule.charAt(ruleCharPos);
                    if (firstVowelPos == 0) {
                        if (replacedCharCount < 1) {
                            ruleOK = -1;
                        }
                    } else if (replacedCharCount < 2 || replacedCharCount < firstVowelPos) {
                        ruleOK = -1;
                    }
                }
                if (ruleOK == 1) {
                    intact = false;
                    lastLetterPos = lastLetterPos + 48 - rule.charAt(ruleCharPos);
                    ++ruleCharPos;
                    stem = stem.substring(0, lastLetterPos + 1);
                    while (ruleCharPos < rule.length() && this.isLetter(rule.charAt(ruleCharPos))) {
                        stem = stem + rule.charAt(ruleCharPos);
                        ++ruleCharPos;
                        ++lastLetterPos;
                    }
                    if (rule.charAt(ruleCharPos) == '.') {
                        done = -1;
                        continue;
                    }
                    done = 1;
                    continue;
                }
                if ((rule = this.ruleTable.elementAt(++currentRuleIndex)).charAt(0) == lastLetter) continue;
                done = -1;
            }
        }
        return stem;
    }

    protected boolean vowel(char ch, char prev) {
        boolean result = CharUtils.isEnglishVowel(ch);
        if (!result && ch == 'y') {
            result = !CharUtils.isEnglishVowel(prev);
        }
        return result;
    }

    protected boolean isDigit(char ch) {
        return CharUtils.isDigit(ch);
    }

    protected boolean isLetter(char ch) {
        return CharUtils.isLetter(ch);
    }

    protected int charCode(char ch) {
        return ch - 97;
    }

    protected String stripPrefixes(String s) {
        String result = s;
        String sLower = s.toLowerCase();
        for (int i = 0; i < prefixes.length; ++i) {
            if (!sLower.startsWith(prefixes[i]) || sLower.length() <= prefixes[i].length()) continue;
            result = s.substring(prefixes[i].length());
            break;
        }
        return result;
    }

    protected String clean(String s) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (!this.isLetter(s.charAt(i))) continue;
            result.append(s.charAt(i));
        }
        return result.toString();
    }

    @Override
    public String stem(String s) {
        String result = s;
        if (result.length() > 3 && this.preStrip) {
            result = this.stripPrefixes(result);
        }
        if (result.length() > 3) {
            result = this.stripSuffixes(result);
        }
        return result;
    }
}

