/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.spellingstandardizer;

import edu.northwestern.at.morphadorner.corpuslinguistics.phonetics.DoubleMetaphone;
import edu.northwestern.at.morphadorner.corpuslinguistics.spellingstandardizer.EnglishDecruftifier;
import edu.northwestern.at.morphadorner.corpuslinguistics.spellingstandardizer.ExtendedSimpleSpellingStandardizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.spellingstandardizer.SpellingStandardizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.stringsimilarity.JaroWinkler;
import edu.northwestern.at.morphadorner.corpuslinguistics.stringsimilarity.LetterEquivalence;
import edu.northwestern.at.morphadorner.corpuslinguistics.stringsimilarity.LetterPairSimilarity;
import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.ScoredString;
import edu.northwestern.at.utils.SortedArrayList;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.spellcheck.SpellingChecker;
import edu.northwestern.at.utils.spellcheck.TernaryTrieBasedSpellingChecker;
import edu.northwestern.at.utils.spellcheck.TernaryTrieSpellingDictionary;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.TreeSet;

public class ExtendedSearchSpellingStandardizer
extends ExtendedSimpleSpellingStandardizer
implements SpellingStandardizer {
    protected SpellingChecker spellingChecker = new TernaryTrieBasedSpellingChecker();
    protected DoubleMetaphone doubleMetaphone = new DoubleMetaphone();

    public void createDictionaries() {
        TernaryTrieSpellingDictionary globalDictionary = null;
        TernaryTrieSpellingDictionary localDictionary = null;
        long startTime = System.currentTimeMillis();
        try {
            globalDictionary = new TernaryTrieSpellingDictionary(this.mappedSpellings);
            localDictionary = new TernaryTrieSpellingDictionary(this.standardSpellingSet);
        }
        catch (Exception e) {
            // empty catch block
        }
        long seconds = (System.currentTimeMillis() - startTime + 999L) / 1000L;
        this.spellingChecker.useGlobalDictionary(globalDictionary);
        this.spellingChecker.useLocalDictionary(localDictionary);
    }

    @Override
    public void loadAlternativeSpellings(Reader reader, String delimChars) throws IOException {
        super.loadAlternativeSpellings(reader, delimChars);
        this.createDictionaries();
    }

    @Override
    public void loadStandardSpellings(Reader reader) throws IOException {
        super.loadStandardSpellings(reader);
        try {
            TernaryTrieSpellingDictionary localDictionary = new TernaryTrieSpellingDictionary(this.standardSpellingSet);
            this.spellingChecker.useLocalDictionary(localDictionary);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Unable to load dictionary of standard spellings.");
        }
    }

    public String[] applyHeuristics(String spelling) {
        String[] results = new String[]{};
        if (spelling.length() > 1) {
            String newSpelling;
            if (spelling.charAt(0) == 'y' && !CharUtils.isEnglishVowel(spelling.charAt(1))) {
                newSpelling = 'i' + spelling.substring(1, spelling.length());
                results = this.spellingChecker.suggest(newSpelling);
            }
            if (results.length == 0 && spelling.charAt(0) == 'v' && !CharUtils.isEnglishVowel(spelling.charAt(1))) {
                newSpelling = 'u' + spelling.substring(1, spelling.length());
                results = this.spellingChecker.suggest(newSpelling);
            }
            if (results.length == 0 && spelling.indexOf("uu") >= 0) {
                newSpelling = StringUtils.replaceAll(spelling, "uu", "w");
                results = this.spellingChecker.suggest(newSpelling);
            }
            if (results.length == 0 && spelling.endsWith("blind") && spelling.length() > 5) {
                newSpelling = spelling.substring(0, spelling.length() - 5) + "-blind";
                results = this.spellingChecker.suggest(newSpelling);
            }
            if (results.length == 0) {
                results = ((TernaryTrieBasedSpellingChecker)this.spellingChecker).suggestMore(spelling);
            }
        }
        return results;
    }

    public String simpleReplacement(String spelling, String pattern, String replacement) {
        String newSpelling;
        String result = "";
        if (spelling.indexOf(pattern) >= 0 && this.mappedSpellings.containsString(newSpelling = spelling.replaceAll(pattern, replacement))) {
            result = this.mappedSpellings.getTag(newSpelling);
        }
        return result;
    }

    public String longSVariant(String spelling) {
        String result = this.simpleReplacement(spelling, "ff", "ss");
        if (result.length() == 0) {
            result = this.simpleReplacement(spelling, "sf", "ss");
        }
        if (result.length() == 0) {
            result = this.simpleReplacement(spelling, "fs", "ss");
        }
        if (result.length() == 0) {
            result = this.simpleReplacement(spelling, "ss", "ff");
        }
        if (result.length() == 0) {
            result = this.simpleReplacement(spelling, "sf", "ff");
        }
        if (result.length() == 0) {
            result = this.simpleReplacement(spelling, "fs", "ff");
        }
        return result;
    }

    @Override
    public String preprocessSpelling(String spelling) {
        String result = EnglishDecruftifier.decruftify(spelling);
        if (CharUtils.hasGapMarkers(result)) {
            result = this.fixGaps(result);
        }
        return result;
    }

    @Override
    public String[] standardizeSpelling(String spelling) {
        String best;
        String result = this.doStandardizeSpelling(spelling, false)[0];
        String lcResult = result.toLowerCase();
        if (!(this.mappedSpellings.containsString(lcResult) || this.standardSpellingSet.contains(lcResult) || (best = this.getBestSuggestedSpelling(result)).equals("?"))) {
            if (this.mappedSpellings.containsString(best)) {
                result = this.mappedSpellings.getTag(best);
            } else {
                result = best;
                this.addCachedSpelling(spelling, result);
            }
        }
        result = this.fixCapitalization(spelling, result);
        return new String[]{result};
    }

    public String getBestSuggestedSpelling(String spelling) {
        String result = spelling;
        SortedArrayList<ScoredString> suggestions = new SortedArrayList<ScoredString>(this.getScoredSuggestedSpellings(spelling));
        if (suggestions.size() > 0) {
            ScoredString suggestion = (ScoredString)suggestions.get(suggestions.size() - 1);
            result = suggestion.getString();
        }
        return result;
    }

    public List<ScoredString> getScoredSuggestedSpellings(String spelling) {
        List<ScoredString> result = ListFactory.createNewList();
        double maxScore = 0.0;
        double maxAdjScore = 0.0;
        int choice = 0;
        String[] suggestions = this.getSuggestedSpellings(spelling);
        this.doubleMetaphone.encode(spelling);
        String dm1 = this.doubleMetaphone.getPrimary();
        String dm2 = this.doubleMetaphone.getAlternate();
        for (int i = 0; i < suggestions.length; ++i) {
            double score = JaroWinkler.jwSimilarity(spelling, suggestions[i]) + LetterPairSimilarity.letterPairSimilarity(spelling, suggestions[i]);
            maxScore = Math.max(maxScore, score /= 2.0);
            this.doubleMetaphone.encode(suggestions[i]);
            if (dm1.equals(this.doubleMetaphone.getPrimary()) || dm2.equals(this.doubleMetaphone.getAlternate())) {
                score += score + 0.2;
            }
            if (suggestions[i].length() == spelling.length()) {
                score += 0.1;
            }
            double denomLength = 3.0 * (double)Math.min(spelling.length(), suggestions[i].length());
            double tieBreaker = LetterEquivalence.letterEquivalence(spelling, suggestions[i]) + StringUtils.matchingInitialCharacters(spelling, suggestions[i]) + StringUtils.matchingFinalCharacters(spelling, suggestions[i]);
            if ((score += tieBreaker / denomLength) > maxAdjScore) {
                maxAdjScore = Math.max(maxAdjScore, score);
                choice = i;
            }
            result.add(new ScoredString(suggestions[i], score));
        }
        if (maxAdjScore > maxScore) {
            double factor = maxScore / maxAdjScore;
            for (int i = 0; i < result.size(); ++i) {
                ScoredString scoredString = result.get(i);
                scoredString.setScore(scoredString.getScore() * factor);
            }
        }
        return result;
    }

    public String[] getSuggestedSpellings(String spelling) {
        String[] suggestions = new String[]{"?"};
        if (!this.spellingChecker.checkSpelling(spelling)) {
            suggestions = this.spellingChecker.suggest(spelling);
            if (suggestions.length == 0) {
                suggestions = this.applyHeuristics(spelling);
            }
            switch (suggestions.length) {
                case 0: {
                    break;
                }
                case 1: {
                    String suggestion = suggestions[0];
                    if (this.mappedSpellings.getTag(suggestion) == null) break;
                    suggestion = this.mappedSpellings.getTag(suggestion);
                    suggestions = new String[]{suggestion};
                    break;
                }
                default: {
                    TreeSet<String> sugs = new TreeSet<String>();
                    for (int j = 0; j < suggestions.length; ++j) {
                        String suggestion = suggestions[j];
                        if (this.mappedSpellings.getTag(suggestion) != null) {
                            suggestion = this.mappedSpellings.getTag(suggestion);
                        }
                        sugs.add(suggestion);
                    }
                    suggestions = sugs.toArray(new String[0]);
                }
            }
        }
        return suggestions;
    }

    @Override
    public String toString() {
        return "Extended Search Spelling Standardizer";
    }
}

