/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.spellingmapper;

import edu.northwestern.at.morphadorner.corpuslinguistics.spellingmapper.SpellingMapper;
import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.IsCloseableObject;
import edu.northwestern.at.utils.Map2D;
import edu.northwestern.at.utils.Map2DFactory;
import edu.northwestern.at.utils.SetFactory;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.TaggedStrings;
import edu.northwestern.at.utils.TernaryTrie;
import edu.northwestern.at.utils.UnicodeReader;
import edu.northwestern.at.utils.logger.DummyLogger;
import edu.northwestern.at.utils.logger.Logger;
import edu.northwestern.at.utils.logger.UsesLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;

public abstract class AbstractSpellingMapper
extends IsCloseableObject
implements SpellingMapper,
UsesLogger {
    protected TaggedStrings mappedSpellings = null;
    protected Set<String> standardSpellingSet = SetFactory.createNewSet();
    protected Map2D<String, String, String> spellingsByWordClass = Map2DFactory.createNewMap2D();
    protected Set<String> alternateSpellingsWordClasses = new TreeSet<String>();
    protected static String spellingsByWordClassFileName = "resources/spellingsbywordclass.txt";
    protected Logger logger = new DummyLogger();

    public AbstractSpellingMapper() {
        try {
            this.loadSpellingsByWordClass();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void loadSpellingsByWordClass() throws IOException {
        String line = null;
        BufferedReader buffer = new BufferedReader(new UnicodeReader(this.getClass().getResourceAsStream(spellingsByWordClassFileName), "utf-8"));
        String wordClass = "";
        String spelling = "";
        String[] tokens = new String[2];
        while ((line = buffer.readLine()) != null) {
            tokens = StringUtils.makeTokenArray(line);
            if (tokens.length <= 0) continue;
            int l = tokens[0].length();
            if (tokens[0].charAt(l - 1) == ':') {
                wordClass = tokens[0].substring(0, l - 1);
                this.alternateSpellingsWordClasses.add(wordClass);
                continue;
            }
            spelling = tokens.length > 1 ? tokens[1] : tokens[0];
            this.spellingsByWordClass.put(wordClass, tokens[0], spelling);
        }
        buffer.close();
    }

    public void loadAlternativeSpellings(URL url, String encoding, String delimChars) throws IOException {
        if (url != null) {
            this.loadAlternativeSpellings(new UnicodeReader(url.openStream(), encoding), delimChars);
        }
    }

    public void loadAlternativeSpellings(Reader reader, String delimChars) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        if (this.mappedSpellings == null) {
            this.mappedSpellings = new TernaryTrie();
        }
        String inputLine = bufferedReader.readLine();
        while (inputLine != null) {
            String[] tokens = inputLine.split(delimChars);
            tokens[0] = tokens[0].trim();
            tokens[1] = tokens[1].trim();
            this.addMappedSpelling(tokens[0], tokens[1]);
            inputLine = bufferedReader.readLine();
        }
        bufferedReader.close();
    }

    public void loadStandardSpellings(URL url, String encoding) throws IOException {
        if (url != null) {
            this.loadStandardSpellings(new UnicodeReader(url.openStream(), encoding));
        }
    }

    public void loadStandardSpellings(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String spelling = bufferedReader.readLine();
        while (spelling != null) {
            this.addStandardSpelling(spelling.trim());
            spelling = bufferedReader.readLine();
        }
        bufferedReader.close();
    }

    public void addMappedSpelling(String alternateSpelling, String standardSpelling) {
        if (this.mappedSpellings != null && standardSpelling != null && standardSpelling.length() > 0 && alternateSpelling != null && alternateSpelling.length() > 0) {
            this.mappedSpellings.putTag(alternateSpelling, standardSpelling);
            this.mappedSpellings.putTag(alternateSpelling.toLowerCase(), standardSpelling);
            this.addStandardSpelling(standardSpelling);
        }
    }

    public void addStandardSpelling(String standardSpelling) {
        if (standardSpelling != null && standardSpelling.length() > 0) {
            this.standardSpellingSet.add(standardSpelling);
            this.standardSpellingSet.add(standardSpelling.toLowerCase());
        }
    }

    public void addStandardSpellings(Collection<String> standardSpellings) {
        for (String spelling : standardSpellings) {
            this.addStandardSpelling(spelling);
        }
    }

    public void addCachedSpelling(String alternateSpelling, String standardSpelling) {
        if (this.mappedSpellings != null && standardSpelling != null && standardSpelling.length() > 0 && alternateSpelling != null && alternateSpelling.length() > 0) {
            this.mappedSpellings.putTag(alternateSpelling, standardSpelling);
            this.mappedSpellings.putTag(alternateSpelling.toLowerCase(), standardSpelling);
        }
    }

    public void setMappedSpellings(TaggedStrings mappedSpellings) {
        this.mappedSpellings = mappedSpellings;
    }

    public void setStandardSpellings(Set<String> standardSpellings) {
        this.standardSpellingSet = standardSpellings;
    }

    public String[] standardizeSpelling(String spelling) {
        String result = spelling;
        String lowerCaseSpelling = spelling.toLowerCase();
        if (this.mappedSpellings != null) {
            if (this.mappedSpellings.containsString(spelling)) {
                result = this.mappedSpellings.getTag(spelling);
            } else if (this.mappedSpellings.containsString(lowerCaseSpelling)) {
                result = this.mappedSpellings.getTag(lowerCaseSpelling);
            } else if (CharUtils.hasDash(spelling)) {
                String spellingNoDashes = CharUtils.evictDashes(spelling);
                if (this.mappedSpellings.containsString(spellingNoDashes)) {
                    result = this.mappedSpellings.getTag(spellingNoDashes);
                } else if (this.mappedSpellings.containsString(spellingNoDashes.toLowerCase())) {
                    result = this.mappedSpellings.getTag(spellingNoDashes.toLowerCase());
                }
            }
        }
        result = this.fixCapitalization(spelling, result);
        return new String[]{result};
    }

    public String standardizeSpelling(String spelling, String wordClass) {
        String[] suggestions;
        String lcSpelling = spelling.toLowerCase();
        String result = this.spellingsByWordClass.get(wordClass, spelling);
        if (result == null) {
            result = this.spellingsByWordClass.get(wordClass, lcSpelling);
        }
        if (result == null && (suggestions = this.standardizeSpelling(spelling)).length > 0) {
            result = suggestions[suggestions.length - 1];
        }
        if (result == null) {
            result = spelling;
        }
        return result;
    }

    public int getNumberOfAlternateSpellings() {
        int result = 0;
        if (this.mappedSpellings != null) {
            result = this.mappedSpellings.getStringCount();
        }
        return result;
    }

    public int getNumberOfStandardSpellings() {
        int result = 0;
        if (this.standardSpellingSet != null) {
            result = this.standardSpellingSet.size();
        }
        return result;
    }

    public TaggedStrings getMappedSpellings() {
        return this.mappedSpellings;
    }

    public Set<String> getStandardSpellings() {
        return this.standardSpellingSet;
    }

    public String preprocessSpelling(String spelling) {
        return spelling;
    }

    public String fixCapitalization(String spelling, String standardSpelling) {
        return CharUtils.makeCaseMatch(standardSpelling, spelling);
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

