/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.sentencesplitter;

import edu.northwestern.at.morphadorner.corpuslinguistics.sentencesplitter.DefaultSentenceSplitterIterator;
import edu.northwestern.at.morphadorner.corpuslinguistics.sentencesplitter.SentenceSplitterIterator;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class SentenceSplitterIteratorFactory {
    public static SentenceSplitterIterator newSentenceSplitterIterator() {
        String className = System.getProperty("sentencesplitteriterator.class");
        if (className == null) {
            className = "DefaultSentenceSplitterIterator";
        }
        return SentenceSplitterIteratorFactory.newSentenceSplitterIterator(className);
    }

    public static SentenceSplitterIterator newSentenceSplitterIterator(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("sentencesplitteriterator.class");
        }
        if (className == null) {
            className = "DefaultSentenceSplitterIterator";
        }
        return SentenceSplitterIteratorFactory.newSentenceSplitterIterator(className);
    }

    public static SentenceSplitterIterator newSentenceSplitterIterator(String className) {
        SentenceSplitterIterator sentenceSplitterIterator = null;
        try {
            sentenceSplitterIterator = (SentenceSplitterIterator)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(SentenceSplitterIteratorFactory.class.getName()) + "." + className;
            try {
                sentenceSplitterIterator = (SentenceSplitterIterator)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create sentence splitter iterator of class " + fixedClassName + ", using default.");
                sentenceSplitterIterator = new DefaultSentenceSplitterIterator();
            }
        }
        return sentenceSplitterIterator;
    }
}

