/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.sentencesplitter;

import edu.northwestern.at.morphadorner.corpuslinguistics.sentencesplitter.DefaultSentenceSplitter;
import edu.northwestern.at.morphadorner.corpuslinguistics.sentencesplitter.SentenceSplitter;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class SentenceSplitterFactory {
    public static SentenceSplitter newSentenceSplitter() {
        String className = System.getProperty("sentencesplitter.class");
        if (className == null) {
            className = "DefaultSentenceSplitter";
        }
        return SentenceSplitterFactory.newSentenceSplitter(className);
    }

    public static SentenceSplitter newSentenceSplitter(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("sentencesplitter.class");
        }
        if (className == null) {
            className = "DefaultSentenceSplitter";
        }
        return SentenceSplitterFactory.newSentenceSplitter(className);
    }

    public static SentenceSplitter newSentenceSplitter(String className) {
        SentenceSplitter sentenceExtractor = null;
        try {
            sentenceExtractor = (SentenceSplitter)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(SentenceSplitterFactory.class.getName()) + "." + className;
            try {
                sentenceExtractor = (SentenceSplitter)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create sentence splitter of class " + fixedClassName + ", using default.");
                sentenceExtractor = new DefaultSentenceSplitter();
            }
        }
        return sentenceExtractor;
    }
}

