/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.sentencemelder;

import edu.northwestern.at.morphadorner.corpuslinguistics.sentencemelder.SentenceMelderState;
import java.util.List;

public class SentenceMelder {
    protected static final String LSQUOTESTR = "\u2018";
    protected static final String RSQUOTESTR = "\u2019";
    protected static final String LDQUOTESTR = "\u201c";
    protected static final String RDQUOTESTR = "\u201d";
    protected SentenceMelderState state = new SentenceMelderState();

    public String reconstituteSentence(List<?> sentence) {
        this.startSentence();
        for (int i = 0; i < sentence.size(); ++i) {
            Object wordObject = sentence.get(i);
            String word = wordObject instanceof String ? (String)wordObject : wordObject.toString();
            if (this.shouldOutputBlank(word, i == 0)) {
                this.outputBlank();
            }
            this.processWord(word);
        }
        return this.endSentence();
    }

    public void startSentence() {
        this.state.sb = new StringBuffer();
        this.state.previousWord = "";
    }

    public void outputBlank() {
        this.state.sb.append(" ");
    }

    protected void outputWord(String word) {
        this.state.sb.append(word);
    }

    public void processWord(String word) {
        this.outputWord(word);
        this.state.previousWord = word;
        ++this.state.wordsDone;
    }

    public String endSentence() {
        String result = this.state.sb.toString().trim();
        result = result.replaceAll("(\"'\")([^\\s])", "$1 $2");
        result = result.replaceAll("('\"')([^\\s])", "$1 $2");
        return result;
    }

    public boolean shouldOutputBlank(String word, boolean isFirstWord) {
        boolean endingPunctuation;
        boolean result = false;
        if (word == null) {
            return result;
        }
        boolean bl = endingPunctuation = word.equals("?") || word.equals("!") || word.equals(".") || word.equals(",") || word.equals(";") || word.equals(":");
        if (word.equals("\"")) {
            boolean bl2 = this.state.inDoubleQuotes = !this.state.inDoubleQuotes;
            if (this.state.inDoubleQuotes) {
                if (!this.state.previousWord.equals("'")) {
                    result = true;
                }
                this.state.doubleQuoteStart = this.state.wordsDone;
            } else {
                if (this.state.inSingleQuotes && this.state.singleQuoteStart > this.state.doubleQuoteStart) {
                    this.state.singleQuoteStart = -1;
                    this.state.inSingleQuotes = false;
                }
                this.state.doubleQuoteStart = -1;
            }
            endingPunctuation = true;
        } else if (word.equals("'")) {
            boolean bl3 = this.state.inSingleQuotes = !this.state.inSingleQuotes;
            if (this.state.inSingleQuotes) {
                if (!this.state.previousWord.equals("\"")) {
                    result = true;
                }
                this.state.singleQuoteStart = this.state.wordsDone;
            } else {
                if (this.state.inDoubleQuotes && this.state.doubleQuoteStart > this.state.singleQuoteStart) {
                    this.state.doubleQuoteStart = -1;
                    this.state.inDoubleQuotes = false;
                }
                this.state.singleQuoteStart = -1;
            }
            endingPunctuation = true;
        }
        if (!(isFirstWord || endingPunctuation || this.state.inDoubleQuotes && this.state.previousWord.equals("\"") || this.state.inSingleQuotes && this.state.previousWord.equals("'") || this.state.previousWord.equals("(") || this.state.previousWord.equals("[") || this.state.previousWord.equals("{") || this.state.previousWord.equals(LDQUOTESTR) || this.state.previousWord.equals(LSQUOTESTR) || word.equals(")") || word.equals("]") || word.equals("}") || word.equals("-") && this.state.previousWord.equals("-") || word.equals(RDQUOTESTR) || word.equals(RSQUOTESTR))) {
            result = true;
        }
        return result;
    }

    public SentenceMelderState getState() {
        return this.state;
    }

    public void setState(SentenceMelderState state) {
        this.state = state;
    }

    public void reset() {
        this.state.reset();
    }
}

