/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.postagger.smoothing.lexical;

import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.smoothing.lexical.DefaultLexicalSmoother;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.smoothing.lexical.LexicalSmoother;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class LexicalSmootherFactory {
    public static LexicalSmoother newLexicalSmoother() {
        String className = System.getProperty("lexicalsmoother.class");
        if (className == null) {
            className = "DefaultLexicalSmoother";
        }
        return LexicalSmootherFactory.newLexicalSmoother(className);
    }

    public static LexicalSmoother newLexicalSmoother(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("lexicalsmoother.class");
        }
        if (className == null) {
            className = "DefaultLexicalSmoother";
        }
        return LexicalSmootherFactory.newLexicalSmoother(className);
    }

    public static LexicalSmoother newLexicalSmoother(String className) {
        LexicalSmoother lexicalSmoother = null;
        try {
            lexicalSmoother = (LexicalSmoother)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(LexicalSmootherFactory.class.getName()) + "." + className;
            try {
                lexicalSmoother = (LexicalSmoother)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create lexical smoother of class " + fixedClassName + ", using default.");
                lexicalSmoother = new DefaultLexicalSmoother();
            }
        }
        return lexicalSmoother;
    }
}

