/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.postagger.smoothing.contextual;

import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.smoothing.contextual.AbstractContextualSmoother;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.smoothing.contextual.ContextualSmoother;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.transitionmatrix.TransitionMatrix;
import edu.northwestern.at.utils.math.Probability;

public class DeletedInterpolationContextualSmoother
extends AbstractContextualSmoother
implements ContextualSmoother {
    protected double[] bigramWeights = null;
    protected double[] trigramWeights = null;

    @Override
    public Probability contextualProbability(String tag, String previousTag) {
        Probability result = null;
        if (this.cachedContextualProbabilities != null) {
            result = (Probability)this.cachedContextualProbabilities.get(previousTag, tag, "*");
        }
        if (result == null) {
            TransitionMatrix transitionMatrix = this.partOfSpeechTagger.getTransitionMatrix();
            if (this.bigramWeights == null) {
                this.bigramWeights = transitionMatrix.getBigramWeights();
            }
            double prob = transitionMatrix.getProbability(previousTag, tag) * this.bigramWeights[1] + transitionMatrix.getProbability(tag) * this.bigramWeights[0];
            result = new Probability(prob);
            if (this.cachedContextualProbabilities != null) {
                this.cachedContextualProbabilities.put(previousTag, tag, "*", result);
            }
        }
        return result;
    }

    @Override
    public Probability contextualProbability(String tag, String previousTag, String previousPreviousTag) {
        Probability result = null;
        if (this.cachedContextualProbabilities != null) {
            result = (Probability)this.cachedContextualProbabilities.get(previousPreviousTag, previousTag, tag);
        }
        if (result == null) {
            TransitionMatrix transitionMatrix = this.partOfSpeechTagger.getTransitionMatrix();
            if (this.trigramWeights == null) {
                this.trigramWeights = transitionMatrix.getTrigramWeights();
            }
            double prob = transitionMatrix.getProbability(previousPreviousTag, previousTag, tag) * this.trigramWeights[2] + transitionMatrix.getProbability(previousTag, tag) * this.trigramWeights[1] + transitionMatrix.getProbability(tag) * this.trigramWeights[0];
            result = new Probability(prob);
            if (this.cachedContextualProbabilities != null) {
                this.cachedContextualProbabilities.put(previousPreviousTag, previousTag, tag, result);
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Using weights computed by deleted interpolation for contextual smoothing.");
        sb.append("\n");
        sb.append("Bigram weights: lambda1=" + this.bigramWeights[0] + ", lambda2=" + this.bigramWeights[1]);
        sb.append("\n");
        sb.append("Trigram weights: lambda1=" + this.trigramWeights[0] + ", lambda2=" + this.trigramWeights[1] + ", lambda3=" + this.trigramWeights[2]);
        sb.append("\n");
        return sb.toString();
    }
}

