/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.postagger.smoothing.contextual;

import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.smoothing.contextual.ContextualSmoother;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.smoothing.contextual.DefaultContextualSmoother;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class ContextualSmootherFactory {
    public static ContextualSmoother newContextualSmoother() {
        String className = System.getProperty("contextualsmoother.class");
        if (className == null) {
            className = "DefaultContextualSmoother";
        }
        return ContextualSmootherFactory.newContextualSmoother(className);
    }

    public static ContextualSmoother newContextualSmoother(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("contextualsmoother.class");
        }
        if (className == null) {
            className = "DefaultContextualSmoother";
        }
        return ContextualSmootherFactory.newContextualSmoother(className);
    }

    public static ContextualSmoother newContextualSmoother(String className) {
        ContextualSmoother contextualSmoother = null;
        try {
            contextualSmoother = (ContextualSmoother)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(ContextualSmoother.class.getName()) + "." + className;
            try {
                contextualSmoother = (ContextualSmoother)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create contextual smoother of class " + fixedClassName + ", using default.");
                contextualSmoother = new DefaultContextualSmoother();
            }
        }
        return contextualSmoother;
    }
}

