/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.postagger.simple;

import edu.northwestern.at.morphadorner.corpuslinguistics.adornedword.AdornedWord;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.AbstractPartOfSpeechTagger;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.CanTagOneWord;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.PartOfSpeechTagger;
import edu.northwestern.at.utils.CharUtils;
import java.util.List;

public class SimpleTagger
extends AbstractPartOfSpeechTagger
implements PartOfSpeechTagger,
CanTagOneWord {
    protected static String nounPOS = "n1";
    protected static String namePOS = "np1";
    protected static String numberPOS = "crd";

    public SimpleTagger() {
    }

    public SimpleTagger(String nounPOS, String namePOS, String numberPOS) {
        SimpleTagger.nounPOS = nounPOS;
        SimpleTagger.namePOS = namePOS;
        SimpleTagger.numberPOS = numberPOS;
    }

    @Override
    public <T extends AdornedWord> List<T> tagAdornedWordList(List<T> sentence) {
        for (int i = 0; i < sentence.size(); ++i) {
            AdornedWord word = (AdornedWord)sentence.get(i);
            this.tagWord(word);
        }
        return sentence;
    }

    @Override
    public String tagWord(String word) {
        String tag = nounPOS;
        if (Character.isUpperCase(word.charAt(0))) {
            tag = namePOS;
        }
        if (CharUtils.isNumber(word)) {
            tag = numberPOS;
        } else if (CharUtils.isPunctuationOrSymbol(word)) {
            tag = word;
        }
        return tag;
    }

    @Override
    public String tagWord(AdornedWord word) {
        String tag = this.tagWord(word.getSpelling());
        word.setPartsOfSpeech(tag);
        return tag;
    }

    public String toString() {
        return "Simple tagger";
    }
}

