/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.postagger.iretagger;

import edu.northwestern.at.morphadorner.corpuslinguistics.adornedword.AdornedWord;
import edu.northwestern.at.morphadorner.corpuslinguistics.adornedword.BaseAdornedWord;
import edu.northwestern.at.morphadorner.corpuslinguistics.partsofspeech.PartOfSpeechTags;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.PartOfSpeechRetagger;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.unigram.UnigramTagger;
import java.util.List;

public class IRetagger
extends UnigramTagger
implements PartOfSpeechRetagger {
    protected static PartOfSpeechTags posTags;
    protected boolean canAddOrDeleteWords = true;

    @Override
    public <T extends AdornedWord> List<T> retagSentence(List<T> sentence) {
        if (posTags == null) {
            posTags = this.getLexicon().getPartOfSpeechTags();
        }
        String prevPosTag = "";
        for (int i = 0; i < sentence.size(); ++i) {
            AdornedWord adornedWord = (AdornedWord)sentence.get(i);
            if (i > 0) {
                prevPosTag = ((AdornedWord)sentence.get(i - 1)).getPartsOfSpeech();
            }
            if (!adornedWord.getSpelling().equals("I.")) continue;
            String partsOfSpeech = adornedWord.getPartsOfSpeech();
            if (this.canAddOrDeleteWords) {
                if (!posTags.isPronounTag(partsOfSpeech)) continue;
                adornedWord.setToken("I");
                adornedWord.setSpelling("I");
                adornedWord.setStandardSpelling("I");
                BaseAdornedWord period = new BaseAdornedWord(".", ".");
                sentence.set(i, adornedWord);
                sentence.add(i + 1, period);
                continue;
            }
            if (!posTags.isNounTag(prevPosTag) || !posTags.isInterjectionTag(partsOfSpeech)) continue;
            adornedWord.setPartsOfSpeech("crd");
        }
        return sentence;
    }

    @Override
    public boolean getCanAddOrDeleteWords() {
        return this.canAddOrDeleteWords;
    }

    @Override
    public void setCanAddOrDeleteWords(boolean canAddOrDeleteWords) {
        this.canAddOrDeleteWords = canAddOrDeleteWords;
    }

    @Override
    public String toString() {
        return "I retagger";
    }
}

