/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.postagger.guesser;

import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.guesser.DefaultPartOfSpeechGuesser;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.guesser.PartOfSpeechGuesser;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class PartOfSpeechGuesserFactory {
    public static PartOfSpeechGuesser newPartOfSpeechGuesser() {
        String className = System.getProperty("partofspeechguesser.class");
        if (className == null) {
            className = "DefaultPartOfSpeechGuesser";
        }
        return PartOfSpeechGuesserFactory.newPartOfSpeechGuesser(className);
    }

    public static PartOfSpeechGuesser newPartOfSpeechGuesser(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("partofspeechguesser.class");
        }
        if (className == null) {
            className = "DefaultPartOfSpeechGuesser";
        }
        return PartOfSpeechGuesserFactory.newPartOfSpeechGuesser(className);
    }

    public static PartOfSpeechGuesser newPartOfSpeechGuesser(String className) {
        PartOfSpeechGuesser partOfSpeechGuesser = null;
        try {
            partOfSpeechGuesser = (PartOfSpeechGuesser)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(PartOfSpeechGuesserFactory.class.getName()) + "." + className;
            try {
                partOfSpeechGuesser = (PartOfSpeechGuesser)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create part of speech guesser of class " + fixedClassName + ", using default.");
                partOfSpeechGuesser = new DefaultPartOfSpeechGuesser();
            }
        }
        return partOfSpeechGuesser;
    }
}

