/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.postagger.guesser;

import edu.northwestern.at.morphadorner.corpuslinguistics.abbreviations.Abbreviations;
import edu.northwestern.at.morphadorner.corpuslinguistics.lexicon.Lexicon;
import edu.northwestern.at.morphadorner.corpuslinguistics.namerecognizer.Names;
import edu.northwestern.at.morphadorner.corpuslinguistics.partsofspeech.PartOfSpeechTags;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.guesser.PartOfSpeechGuesser;
import edu.northwestern.at.morphadorner.corpuslinguistics.spellingstandardizer.ExtendedSimpleSpellingStandardizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.spellingstandardizer.SpellingStandardizer;
import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.IsCloseableObject;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.MutableInteger;
import edu.northwestern.at.utils.RomanNumeralUtils;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.TaggedStrings;
import edu.northwestern.at.utils.cache.Cache;
import edu.northwestern.at.utils.cache.LRUCache;
import edu.northwestern.at.utils.logger.DummyLogger;
import edu.northwestern.at.utils.logger.Logger;
import edu.northwestern.at.utils.logger.UsesLogger;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractPartOfSpeechGuesser
extends IsCloseableObject
implements PartOfSpeechGuesser,
UsesLogger {
    protected boolean debug = false;
    protected Logger logger = new DummyLogger();
    protected Abbreviations abbreviations = new Abbreviations();
    protected Cache<String, Map<String, MutableInteger>> cachedWords = new LRUCache<String, Map<String, MutableInteger>>(2000);
    protected Map<String, Lexicon> cachedLexicons = MapFactory.createNewMap();
    protected Lexicon wordLexicon;
    protected Lexicon suffixLexicon;
    protected SpellingStandardizer spellingStandardizer;
    protected SpellingStandardizer auxiliarySpellingStandardizer = new ExtendedSimpleSpellingStandardizer();
    protected List<TaggedStrings> auxiliaryWordLists = ListFactory.createNewList();
    protected Names names = new Names();
    protected boolean tryStandardSpellings = true;
    protected boolean checkPossessives = false;

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public SpellingStandardizer getSpellingStandardizer() {
        return this.spellingStandardizer;
    }

    @Override
    public void setSpellingStandardizer(SpellingStandardizer spellingStandardizer) {
        this.spellingStandardizer = spellingStandardizer;
        this.auxiliarySpellingStandardizer.setMappedSpellings(spellingStandardizer.getMappedSpellings());
    }

    @Override
    public void setAbbreviations(Abbreviations abbreviations) {
        this.abbreviations = abbreviations;
    }

    @Override
    public Lexicon getWordLexicon() {
        return this.wordLexicon;
    }

    @Override
    public void setWordLexicon(Lexicon wordLexicon) {
        this.wordLexicon = wordLexicon;
    }

    @Override
    public Lexicon getSuffixLexicon() {
        return this.suffixLexicon;
    }

    @Override
    public void setSuffixLexicon(Lexicon suffixLexicon) {
        this.suffixLexicon = suffixLexicon;
    }

    protected void addCachedWord(String word, Map<String, MutableInteger> tagMap) {
        this.cachedWords.put(word, tagMap);
    }

    protected Map<String, MutableInteger> posTagToMap(String posTag) {
        Map<String, MutableInteger> result = MapFactory.createNewMap();
        int count = Math.max(1, this.wordLexicon.getCategoryCount(posTag));
        result.put(posTag, new MutableInteger(count));
        return result;
    }

    protected Map<String, MutableInteger> posTagsToMap(String[] posTags) {
        Map<String, MutableInteger> result = MapFactory.createNewMap();
        for (int i = 0; i < posTags.length; ++i) {
            int count = Math.max(1, this.wordLexicon.getCategoryCount(posTags[i]));
            result.put(posTags[i], new MutableInteger(count));
        }
        return result;
    }

    protected Map<String, MutableInteger> clonePosTagMap(Map<String, MutableInteger> posTagMap) {
        Map<String, MutableInteger> result = null;
        if (posTagMap != null) {
            result = MapFactory.createNewMap(posTagMap.size());
            for (String tag : posTagMap.keySet()) {
                MutableInteger count = posTagMap.get(tag);
                result.put(new String(tag), new MutableInteger(count.intValue()));
            }
        }
        return result;
    }

    @Override
    public void addAuxiliaryWordList(TaggedStrings wordList) {
        if (wordList != null && wordList.getStringCount() > 0) {
            this.auxiliaryWordLists.add(wordList);
        }
    }

    @Override
    public List<TaggedStrings> getAuxiliaryWordLists() {
        return this.auxiliaryWordLists;
    }

    @Override
    public Lexicon getCachedLexiconForWord(String word) {
        Lexicon result = this.cachedLexicons.get(word);
        if (result == null) {
            result = this.wordLexicon;
        }
        return result;
    }

    public Map<String, MutableInteger> checkCachedWord(String word) {
        Map<String, MutableInteger> result = null;
        if (this.cachedWords.containsKey(word)) {
            result = this.cachedWords.get(word);
        } else {
            String lowerCaseWord = word.toLowerCase();
            if (this.cachedWords.containsKey(lowerCaseWord)) {
                result = this.cachedWords.get(lowerCaseWord);
            }
        }
        return result;
    }

    public Map<String, MutableInteger> checkName(String word) {
        String fixedWord;
        Map<String, MutableInteger> result = null;
        if (this.names.isNameOrPlace(word)) {
            result = this.posTagToMap(this.wordLexicon.getPartOfSpeechTags().getSingularProperNounTag());
            this.addCachedWord(word, result);
        } else if (CharUtils.isAllCaps(word) && this.names.isNameOrPlace(fixedWord = CharUtils.capitalizeFirstLetter(word))) {
            result = this.posTagToMap(this.wordLexicon.getPartOfSpeechTags().getSingularProperNounTag());
            this.addCachedWord(word, result);
        }
        return result;
    }

    public Map<String, MutableInteger> checkPossessiveNoun(String word) {
        Map<String, MutableInteger> result = null;
        if (this.checkPossessives && CharUtils.endsWithSingleQuoteS(word)) {
            String strippedWord = word.substring(0, word.length() - 2);
            result = this.names.isNameOrPlace(strippedWord) ? this.posTagToMap(this.wordLexicon.getPartOfSpeechTags().getPossessiveSingularProperNounTag()) : (Character.isUpperCase(strippedWord.charAt(0)) ? this.posTagToMap(this.wordLexicon.getPartOfSpeechTags().getPossessiveSingularProperNounTag()) : this.posTagToMap(this.wordLexicon.getPartOfSpeechTags().getPossessiveSingularNounTag()));
        }
        if (result != null) {
            this.addCachedWord(word, result);
        }
        return result;
    }

    public Map<String, MutableInteger> checkAllUpperCase(String word) {
        Map<String, MutableInteger> result = null;
        if (CharUtils.allLettersCapital(word)) {
            result = this.posTagToMap(this.wordLexicon.getPartOfSpeechTags().getSingularProperNounTag());
            this.addCachedWord(word, result);
        }
        return result;
    }

    public Map<String, MutableInteger> checkNumber(String word) {
        Map<String, MutableInteger> result = null;
        String fixedWord = word.replaceAll(",", "");
        if (CharUtils.isNumber(fixedWord)) {
            result = this.posTagToMap(this.wordLexicon.getPartOfSpeechTags().getCardinalNumberTag());
            this.addCachedWord(word, result);
        } else if (CharUtils.isOrdinal(fixedWord)) {
            result = this.posTagToMap(this.wordLexicon.getPartOfSpeechTags().getOrdinalNumberTag());
            this.addCachedWord(word, result);
        }
        return result;
    }

    public Map<String, MutableInteger> checkCurrency(String word) {
        Map<String, MutableInteger> result = null;
        if (CharUtils.isCurrency(word) || CharUtils.isUSCurrency(word) || CharUtils.isUSCurrencyCents(word)) {
            result = this.posTagToMap(this.wordLexicon.getPartOfSpeechTags().getCardinalNumberTag());
            this.addCachedWord(word, result);
        }
        return result;
    }

    public Map<String, MutableInteger> checkRomanNumeral(String word) {
        Map<String, MutableInteger> result = null;
        if (RomanNumeralUtils.isLooseRomanNumeral(word)) {
            result = Abbreviations.isInitial(word) ? this.posTagsToMap(new String[]{this.wordLexicon.getPartOfSpeechTags().getCardinalNumberTag(), this.wordLexicon.getPartOfSpeechTags().getSingularProperNounTag()}) : this.posTagToMap(this.wordLexicon.getPartOfSpeechTags().getCardinalNumberTag());
            this.addCachedWord(word, result);
        } else if (RomanNumeralUtils.isLooseOrdinalRomanNumeral(word)) {
            result = this.posTagToMap(this.wordLexicon.getPartOfSpeechTags().getOrdinalNumberTag());
            this.addCachedWord(word, result);
        }
        return result;
    }

    public Map<String, MutableInteger> checkAuxiliaryWordLists(String word) {
        Map<String, MutableInteger> result = null;
        for (int i = 0; i < this.auxiliaryWordLists.size(); ++i) {
            TaggedStrings wordList = this.auxiliaryWordLists.get(i);
            if (wordList.containsString(word)) {
                result = this.posTagsToMap(StringUtils.makeTokenArray(wordList.getTag(word)));
                break;
            }
            String lowerWord = word.toLowerCase();
            if (!wordList.containsString(lowerWord)) continue;
            result = this.posTagsToMap(StringUtils.makeTokenArray(wordList.getTag(lowerWord)));
            break;
        }
        return result;
    }

    public Map<String, MutableInteger> checkPunctuation(String word) {
        Map<String, MutableInteger> result = null;
        if (CharUtils.isPunctuation(word)) {
            result = this.posTagToMap(word);
            this.addCachedWord(word, result);
        }
        return result;
    }

    public Map<String, MutableInteger> checkSymbol(String word) {
        Map<String, MutableInteger> result = null;
        if (CharUtils.isSymbol(word)) {
            result = this.posTagToMap(this.wordLexicon.getPartOfSpeechTags().getSymbolTag());
            this.addCachedWord(word, result);
        }
        return result;
    }

    public Map<String, MutableInteger> checkAbbreviation(String word) {
        Map<String, MutableInteger> result = null;
        if (this.abbreviations.isAbbreviation(word)) {
            result = Character.isUpperCase(word.charAt(0)) ? this.posTagToMap(this.wordLexicon.getPartOfSpeechTags().getSingularProperNounTag()) : this.posTagToMap(this.wordLexicon.getPartOfSpeechTags().getSingularNounTag());
            this.addCachedWord(word, result);
        }
        return result;
    }

    public Map<String, MutableInteger> checkHyphenatedWord(String word) {
        Map<String, MutableInteger> result = null;
        int dashPos = word.lastIndexOf(45);
        if (dashPos >= 0) {
            String commonPossessiveNounTag;
            if (word.matches("[A-Z](--|---)'(s|S)")) {
                String properPossessiveNounTag = this.wordLexicon.getPartOfSpeechTags().getPossessiveSingularProperNounTag();
                result = this.posTagsToMap(new String[]{properPossessiveNounTag});
            } else if (word.matches("[a-z](--|---)'(s|S)")) {
                commonPossessiveNounTag = this.wordLexicon.getPartOfSpeechTags().getPossessiveSingularNounTag();
                result = this.posTagsToMap(new String[]{commonPossessiveNounTag});
            } else if (word.matches("(--|---)'(s|S)")) {
                commonPossessiveNounTag = this.wordLexicon.getPartOfSpeechTags().getPossessiveSingularNounTag();
                String properPossessiveNounTag = this.wordLexicon.getPartOfSpeechTags().getPossessiveSingularProperNounTag();
                result = this.posTagsToMap(new String[]{commonPossessiveNounTag, properPossessiveNounTag});
            } else if (word.matches("[A-Z](--|---)")) {
                String properNounTag = this.wordLexicon.getPartOfSpeechTags().getSingularProperNounTag();
                String interjectionTag = this.wordLexicon.getPartOfSpeechTags().getInterjectionTag();
                result = this.posTagsToMap(new String[]{properNounTag, interjectionTag});
            } else if (word.matches("[a-z](--|---)")) {
                String commonNounTag = this.wordLexicon.getPartOfSpeechTags().getSingularNounTag();
                String interjectionTag = this.wordLexicon.getPartOfSpeechTags().getInterjectionTag();
                result = this.posTagsToMap(new String[]{commonNounTag, interjectionTag});
            } else if (dashPos < word.length() - 1) {
                String suffix = word.substring(dashPos + 1);
                result = this.wordLexicon.getCategoryCountsForEntry(suffix);
                if (result == null) {
                    result = this.clonePosTagMap(this.wordLexicon.getCategoryCountsForEntry(suffix.toLowerCase()));
                }
                if (result != null) {
                    int maxCount = 0;
                    String maxPos = "";
                    for (String pos : result.keySet()) {
                        int catCount = result.get(pos).intValue();
                        if (catCount <= maxCount) continue;
                        maxCount = catCount;
                        maxPos = pos;
                    }
                    result = this.wordLexicon.getPartOfSpeechTags().isNounTag(maxPos) ? this.posTagToMap(maxPos) : null;
                }
            }
            if (result == null) {
                String adjectiveTag = this.wordLexicon.getPartOfSpeechTags().getAdjectiveTag();
                result = this.posTagToMap(adjectiveTag);
            }
            if (result != null) {
                this.addCachedWord(word, result);
            }
        }
        return result;
    }

    protected String[] getStandardizedSpellings(String word) {
        String[] result = null;
        if (this.tryStandardSpellings) {
            if (this.spellingStandardizer != null && (result = this.spellingStandardizer.standardizeSpelling(word)).length == 0) {
                result = this.spellingStandardizer.standardizeSpelling(word.toLowerCase());
            }
        } else if (this.auxiliarySpellingStandardizer != null && (result = this.auxiliarySpellingStandardizer.standardizeSpelling(word)).length == 0) {
            result = this.auxiliarySpellingStandardizer.standardizeSpelling(word.toLowerCase());
        }
        return result;
    }

    protected Map<String, MutableInteger> checkStandardSpellings(String word, String[] standardSpellings) {
        Map<String, MutableInteger> result = null;
        if (this.spellingStandardizer != null) {
            switch (standardSpellings.length) {
                case 0: {
                    break;
                }
                default: {
                    String standardSpelling = standardSpellings[0];
                    if (this.wordLexicon.getEntryCount(standardSpelling) > 0) {
                        result = this.clonePosTagMap(this.wordLexicon.getCategoryCountsForEntry(standardSpelling));
                        this.addCachedWord(word, result);
                        return result;
                    }
                    result = this.checkName(standardSpelling);
                }
            }
        }
        return result;
    }

    public void removeProperNounTags(Map<String, MutableInteger> posTagsMap) {
        PartOfSpeechTags posTags = this.wordLexicon.getPartOfSpeechTags();
        Iterator<String> iterator = posTagsMap.keySet().iterator();
        while (iterator.hasNext()) {
            String tag = iterator.next();
            if (!posTags.isProperNounTag(tag) && !posTags.isProperAdjectiveTag(tag)) continue;
            iterator.remove();
        }
        if (posTagsMap.size() == 0) {
            posTagsMap = null;
        }
    }

    public void removeCompoundTags(Map<String, MutableInteger> posTagsMap) {
        PartOfSpeechTags posTags = this.wordLexicon.getPartOfSpeechTags();
        Iterator<String> iterator = posTagsMap.keySet().iterator();
        while (iterator.hasNext()) {
            String tag = iterator.next();
            if (!posTags.isCompoundTag(tag)) continue;
            iterator.remove();
        }
        if (posTagsMap.size() == 0) {
            posTagsMap = null;
        }
    }

    public Map<String, MutableInteger> checkSuffixes(String word) {
        Map<String, MutableInteger> result = null;
        int maxSuffixLength = this.suffixLexicon.getLongestEntryLength();
        int minSuffixLength = this.suffixLexicon.getShortestEntryLength();
        int l = word.length();
        boolean hasCap = CharUtils.hasCapitalLetter(word);
        boolean hasApos = CharUtils.hasApostrophe(word);
        for (int i = Math.min(maxSuffixLength, l); i > minSuffixLength - 1; --i) {
            String suffix = word.substring(l - i, l);
            if (this.suffixLexicon.getEntryCount(suffix) <= 0) continue;
            result = this.clonePosTagMap(this.suffixLexicon.getCategoryCountsForEntry(suffix));
            if (!hasCap) {
                this.removeProperNounTags(result);
            }
            if (!hasApos) {
                this.removeCompoundTags(result);
            }
            if (result == null || result.size() <= 0) continue;
            this.addCachedWord(word, result);
            this.cachedLexicons.put(word, this.suffixLexicon);
            return result;
        }
        if (result != null && result.size() == 0) {
            result = null;
        }
        return result;
    }

    public Map<String, MutableInteger> checkSuffixes(String word, String[] standardSpellings) {
        Map<String, MutableInteger> result = null;
        boolean hasApos = CharUtils.hasApostrophe(word);
        if (hasApos && !word.endsWith("'s") && this.tryStandardSpellings && standardSpellings != null && standardSpellings.length > 0) {
            for (int i = 0; i < standardSpellings.length && (result = this.checkSuffixes(standardSpellings[i])) == null; ++i) {
            }
            if (result == null) {
                result = this.checkSuffixes(word);
            }
        } else {
            result = this.checkSuffixes(word);
            if (result == null && this.tryStandardSpellings && standardSpellings != null && standardSpellings.length > 0) {
                for (int i = 0; i < standardSpellings.length && (result = this.checkSuffixes(standardSpellings[i])) == null; ++i) {
                }
            }
        }
        return result;
    }

    public Map<String, MutableInteger> getNoun(String word) {
        Map<String, MutableInteger> result = null;
        char firstChar = word.charAt(0);
        char lastChar = word.charAt(word.length() - 1);
        result = Character.isUpperCase(firstChar) ? (lastChar == 's' || lastChar == 'S' ? this.posTagToMap(this.wordLexicon.getPartOfSpeechTags().getPluralProperNounTag()) : this.posTagToMap(this.wordLexicon.getPartOfSpeechTags().getSingularProperNounTag())) : (lastChar == 's' || lastChar == 'S' ? this.posTagToMap(this.wordLexicon.getPartOfSpeechTags().getPluralNounTag()) : this.posTagToMap(this.wordLexicon.getPartOfSpeechTags().getSingularNounTag()));
        this.addCachedWord(word, result);
        return result;
    }

    @Override
    public Map<String, MutableInteger> guessPartsOfSpeech(String word, boolean isFirstWord) {
        return this.guessPartsOfSpeech(word);
    }

    @Override
    public void setTryStandardSpellings(boolean tryStandardSpellings) {
        this.tryStandardSpellings = tryStandardSpellings;
    }

    @Override
    public void setCheckPossessives(boolean checkPossessives) {
        this.checkPossessives = checkPossessives;
    }

    @Override
    public abstract Map<String, MutableInteger> guessPartsOfSpeech(String var1);
}

