/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.postagger;

import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.DefaultPartOfSpeechRetagger;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.PartOfSpeechRetagger;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.UTF8Properties;
import java.util.Map;

public class PartOfSpeechRetaggerFactory {
    protected static Map<String, String> retaggerClassMap = MapFactory.createNewMap();

    public static PartOfSpeechRetagger newPartOfSpeechRetagger() {
        String className = System.getProperty("partofspeechretagger.class");
        if (className == null) {
            className = ClassUtils.packageName(PartOfSpeechRetaggerFactory.class.getName()) + "DefaultPartOfSpeechRetagger";
        }
        return PartOfSpeechRetaggerFactory.newPartOfSpeechRetagger(className);
    }

    public static PartOfSpeechRetagger newPartOfSpeechRetagger(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("partofspeechretagger.class");
        }
        if (className == null) {
            className = ClassUtils.packageName(PartOfSpeechRetaggerFactory.class.getName()) + "DefaultPartOfSpeechRetagger";
        }
        return PartOfSpeechRetaggerFactory.newPartOfSpeechRetagger(className);
    }

    public static PartOfSpeechRetagger newPartOfSpeechRetagger(String className) {
        PartOfSpeechRetagger partOfSpeechRetagger = null;
        try {
            partOfSpeechRetagger = (PartOfSpeechRetagger)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = retaggerClassMap.get(className);
            if (fixedClassName != null) {
                try {
                    partOfSpeechRetagger = (PartOfSpeechRetagger)Class.forName(fixedClassName).newInstance();
                }
                catch (Exception e2) {
                    System.err.println("Unable to create part of speech retagger of class " + fixedClassName + ", using default retagger.");
                    partOfSpeechRetagger = new DefaultPartOfSpeechRetagger();
                }
            }
            System.err.println("Unable to create part of speech retagger of class " + className + ", using default retagger.");
            partOfSpeechRetagger = new DefaultPartOfSpeechRetagger();
        }
        return partOfSpeechRetagger;
    }

    static {
        String classPrefix = ClassUtils.packageName(PartOfSpeechRetaggerFactory.class.getName());
        retaggerClassMap.put("DefaultPartOfSpeechRetagger", classPrefix + ".DefaultPartOfSpeechRetagger");
        retaggerClassMap.put("HeppleTagger", classPrefix + ".hepple.HeppleTagger");
        retaggerClassMap.put("IRetagger", classPrefix + ".iretagger.IRetagger");
        retaggerClassMap.put("NoopRetagger", classPrefix + ".noopretagger.NoopRetagger");
        retaggerClassMap.put("ProperNounRetagger", classPrefix + ".propernounretagger.ProperNounRetagger");
        retaggerClassMap.put("SimpleRuleBasedTagger", classPrefix + ".simplerulebased.SimpleRuleBasedTagger");
        retaggerClassMap.put("TCPRetagger", classPrefix + ".tcpretagger.TCPRetagger");
    }
}

