/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.phonetics;

public class Soundex {
    public static final char[] US_ENGLISH_SOUNDEX_MAPPING = "01230120022455012623010202".toCharArray();
    public static final int MAXSOUNDEXLENGTH = 4;

    public static String soundex(String s) {
        int i;
        if (s == null || s.length() == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        String sUpperCase = s.toUpperCase();
        char previousC = '0';
        char c = sUpperCase.charAt(0);
        if (c < 'A' || c > 'Z') {
            return "";
        }
        result.append(c);
        for (i = 1; i < sUpperCase.length() && result.length() < 4; ++i) {
            c = sUpperCase.charAt(i);
            if (c < 'A' || c > 'Z' || c == previousC) continue;
            previousC = c;
            char mappedC = US_ENGLISH_SOUNDEX_MAPPING[c - 65];
            if (mappedC == '0') continue;
            result.append(mappedC);
        }
        if (result.length() > 0) {
            for (i = result.length(); i < 4; ++i) {
                result.append('0');
            }
        }
        return result.toString();
    }
}

