/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.outputter;

import edu.northwestern.at.morphadorner.corpuslinguistics.outputter.AdornedWordOutputter;
import edu.northwestern.at.morphadorner.corpuslinguistics.outputter.DefaultAdornedWordOutputter;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class AdornedWordOutputterFactory {
    public static AdornedWordOutputter newAdornedWordOutputter() {
        String className = System.getProperty("adornedwordoutputter.class");
        if (className == null) {
            className = "DefaultAdornedWordOutputter";
        }
        return AdornedWordOutputterFactory.newAdornedWordOutputter(className);
    }

    public static AdornedWordOutputter newAdornedWordOutputter(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("adornedwordoutputter.class");
        }
        if (className == null) {
            className = "DefaultAdornedWordOutputter";
        }
        return AdornedWordOutputterFactory.newAdornedWordOutputter(className);
    }

    public static AdornedWordOutputter newAdornedWordOutputter(String className) {
        AdornedWordOutputter adornedWordOutputter = null;
        try {
            adornedWordOutputter = (AdornedWordOutputter)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(AdornedWordOutputterFactory.class.getName()) + "." + className;
            try {
                adornedWordOutputter = (AdornedWordOutputter)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create adorned word outputter of class " + fixedClassName + ", using default.");
                adornedWordOutputter = new DefaultAdornedWordOutputter();
            }
        }
        return adornedWordOutputter;
    }
}

