/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.namerecognizer;

import edu.northwestern.at.morphadorner.corpuslinguistics.lexicon.Lexicon;
import edu.northwestern.at.morphadorner.corpuslinguistics.tokenizer.DefaultWordTokenizer;
import edu.northwestern.at.utils.MapUtils;
import edu.northwestern.at.utils.SetFactory;
import edu.northwestern.at.utils.SetUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Names {
    protected static String defaultResourcePath = "resources/";
    protected static Set<String> surnameSet = null;
    protected static Set<String> firstNameSet = null;
    protected static Map<String, String> placeNameMap = null;
    protected static Set<String> prefixSet = null;
    protected static Set<String> connectorsSet = null;

    public Names() {
        this(defaultResourcePath);
    }

    public Names(String resourcePath) {
        if (surnameSet != null) {
            return;
        }
        try {
            surnameSet = SetUtils.loadSet(Names.class.getResource(resourcePath + "lastnames.txt"), "utf-8");
            firstNameSet = SetUtils.loadSet(Names.class.getResource(resourcePath + "firstnames.txt"), "utf-8");
            placeNameMap = MapUtils.loadMap(Names.class.getResource(resourcePath + "placenames.txt"), "\t", "", "utf-8");
            prefixSet = SetUtils.loadSet(Names.class.getResource(resourcePath + "prefixes.txt"), "utf-8");
            connectorsSet = SetUtils.loadSet(Names.class.getResource(resourcePath + "connectors.txt"), "utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isNameOrPlace(String s) {
        return firstNameSet.contains(s) || surnameSet.contains(s) || placeNameMap.containsKey(s);
    }

    protected boolean acceptName(Lexicon lexicon, String name, boolean firstWord, int numWords) {
        boolean result;
        boolean bl = result = name.length() > 0;
        if (result && firstWord && numWords == 1 && lexicon != null) {
            String lowerCaseName = name.toLowerCase().trim();
            result = !lexicon.containsEntry(lowerCaseName);
        }
        return result;
    }

    public Set<String>[] getProperNames(String[] words, Lexicon lexicon) {
        Set<String> personNames = SetFactory.createNewSet();
        Set<String> placeNames = SetFactory.createNewSet();
        if (words == null || words.length == 0) {
            Set[] result = new Set[]{personNames, placeNames};
            return result;
        }
        block0: for (int i = 0; i < words.length; ++i) {
            for (int j = 5; j > 0; --j) {
                String name;
                if (j <= 3 && (name = this.getPlaceName(words, i, j)).length() > 0 && this.acceptName(lexicon, name, i == 0, j)) {
                    placeNames.add(name);
                    i += j - 1;
                    continue block0;
                }
                name = this.getPersonName(words, i, j);
                if (name.length() <= 0 || !this.acceptName(lexicon, name, i == 0, j)) continue;
                personNames.add(name);
                i += j - 1;
                continue block0;
            }
        }
        Set[] result = new Set[]{personNames, placeNames};
        return result;
    }

    public Set<String>[] getProperNames(String s, Lexicon lexicon) {
        DefaultWordTokenizer wordTokenizer = new DefaultWordTokenizer();
        List<String> wordsList = wordTokenizer.extractWords(s);
        String[] words = wordsList.toArray(new String[wordsList.size()]);
        return this.getProperNames(words, lexicon);
    }

    public Set<String>[] getProperNames(List<String> wordsList, Lexicon lexicon) {
        String[] words = wordsList.toArray(new String[wordsList.size()]);
        return this.getProperNames(words, lexicon);
    }

    public String getPlaceName(String[] words, int startIndex, int numWords) {
        String result = "";
        if (startIndex + numWords > words.length) {
            return result;
        }
        StringBuffer sb = new StringBuffer();
        int endIndex = startIndex + numWords - 1;
        for (int i = startIndex; i <= endIndex; ++i) {
            sb.append(words[startIndex]);
            if (i >= endIndex) continue;
            sb.append(" ");
        }
        String s = sb.toString();
        if (this.isPlaceName(s)) {
            result = s;
        }
        return result.trim();
    }

    public String getPlaceNameType(String placeName) {
        String result = placeNameMap.get(placeName);
        if (result == null) {
            result = "";
        }
        return result.trim();
    }

    public boolean isPlaceName(String name) {
        return placeNameMap.get(name) != null;
    }

    public boolean isNamePrefix(String word) {
        return word != null && prefixSet.contains(word);
    }

    public boolean isPersonName(String s) {
        DefaultWordTokenizer wordTokenizer = new DefaultWordTokenizer();
        List<String> wordsList = wordTokenizer.extractWords(s);
        String[] words = wordsList.toArray(new String[wordsList.size()]);
        return this.isPersonName(words);
    }

    public String getPersonName(String[] words, int startIndex, int numWords) {
        String result = "";
        if (startIndex + numWords > words.length) {
            return result;
        }
        String[] sWords = new String[numWords];
        int endIndex = startIndex + numWords - 1;
        int j = 0;
        for (int i = startIndex; i <= endIndex; ++i) {
            sWords[j++] = words[i];
        }
        if (this.isPersonName(sWords)) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < sWords.length; ++i) {
                sb.append(sWords[i]);
                if (i >= sWords.length) continue;
                sb.append(" ");
            }
            result = sb.toString();
        }
        return result.trim();
    }

    public boolean isPersonName(String[] words) {
        boolean result = false;
        switch (words.length) {
            case 1: {
                result = firstNameSet.contains(words[0]) || surnameSet.contains(words[0]);
                break;
            }
            case 2: {
                result = firstNameSet.contains(words[0]) && surnameSet.contains(words[1]);
                result = result || prefixSet.contains(words[0]) && surnameSet.contains(words[1]);
                break;
            }
            case 3: {
                result = firstNameSet.contains(words[0]) && firstNameSet.contains(words[1]) && surnameSet.contains(words[2]);
                result = result || prefixSet.contains(words[0]) && firstNameSet.contains(words[1]) && surnameSet.contains(words[2]);
                result = result || firstNameSet.contains(words[0]) && connectorsSet.contains(words[1]) && surnameSet.contains(words[2]);
                result = result || firstNameSet.contains(words[0]) && words[1].length() == 2 && words[1].endsWith(".") && surnameSet.contains(words[2]);
                break;
            }
            case 4: {
                result = firstNameSet.contains(words[0]) && firstNameSet.contains(words[1]) && firstNameSet.contains(words[2]) && surnameSet.contains(words[3]);
                result = result || prefixSet.contains(words[0]) && firstNameSet.contains(words[1]) && firstNameSet.contains(words[2]) && surnameSet.contains(words[3]);
                result = result || prefixSet.contains(words[0]) && firstNameSet.contains(words[1]) && words[2].length() == 1 && surnameSet.contains(words[3]);
                result = firstNameSet.contains(words[0]) && firstNameSet.contains(words[1]) && words[2].length() == 2 && words[2].endsWith(".") && surnameSet.contains(words[3]);
                result = result || prefixSet.contains(words[0]) && firstNameSet.contains(words[1]) && words[2].length() == 2 && words[2].endsWith(".") && surnameSet.contains(words[3]);
                result = result || firstNameSet.contains(words[0]) && firstNameSet.contains(words[1]) && firstNameSet.contains(words[2]) && surnameSet.contains(words[3]);
                result = result || firstNameSet.contains(words[0]) && connectorsSet.contains(words[1]) && connectorsSet.contains(words[2]) && surnameSet.contains(words[3]);
                break;
            }
            case 5: {
                result = result || prefixSet.contains(words[0]) && firstNameSet.contains(words[1]) && connectorsSet.contains(words[2]) && connectorsSet.contains(words[3]) && surnameSet.contains(words[4]);
                break;
            }
        }
        return result;
    }

    public Set<String> getFirstNames() {
        return firstNameSet;
    }

    public Set<String> getSurnames() {
        return surnameSet;
    }

    public Map<String, String> getPlaceNames() {
        return placeNameMap;
    }

    public Set<String> getPrefixes() {
        return prefixSet;
    }

    public Set<String> getConnectors() {
        return connectorsSet;
    }
}

