/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.namerecognizer;

import edu.northwestern.at.morphadorner.corpuslinguistics.adornedword.AdornedWord;
import edu.northwestern.at.morphadorner.corpuslinguistics.lexicon.Lexicon;
import edu.northwestern.at.morphadorner.corpuslinguistics.lexicon.UsesLexicon;
import edu.northwestern.at.morphadorner.corpuslinguistics.namerecognizer.NamePosition;
import edu.northwestern.at.morphadorner.corpuslinguistics.namerecognizer.NameRecognizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.namerecognizer.Names;
import edu.northwestern.at.morphadorner.corpuslinguistics.partsofspeech.PartOfSpeechTags;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.DefaultPartOfSpeechTagger;
import edu.northwestern.at.morphadorner.corpuslinguistics.postagger.PartOfSpeechTagger;
import edu.northwestern.at.morphadorner.corpuslinguistics.sentencesplitter.DefaultSentenceSplitter;
import edu.northwestern.at.morphadorner.corpuslinguistics.sentencesplitter.SentenceSplitter;
import edu.northwestern.at.morphadorner.corpuslinguistics.tokenizer.DefaultWordTokenizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.tokenizer.WordTokenizer;
import edu.northwestern.at.utils.IsCloseableObject;
import edu.northwestern.at.utils.logger.DummyLogger;
import edu.northwestern.at.utils.logger.Logger;
import edu.northwestern.at.utils.logger.UsesLogger;
import java.util.List;
import java.util.Set;

public abstract class AbstractNameRecognizer
extends IsCloseableObject
implements NameRecognizer,
UsesLexicon,
UsesLogger {
    protected Lexicon lexicon = null;
    protected PartOfSpeechTagger partOfSpeechTagger = null;
    protected WordTokenizer wordTokenizer = null;
    protected SentenceSplitter sentenceSplitter = null;
    protected PartOfSpeechTags partOfSpeechTags = null;
    protected Names names = new Names();
    protected Logger logger = new DummyLogger();

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public Lexicon getLexicon() {
        return this.lexicon;
    }

    @Override
    public void setLexicon(Lexicon lexicon) {
        this.lexicon = lexicon;
    }

    @Override
    public PartOfSpeechTagger getPartOfSpeechTagger() {
        return this.partOfSpeechTagger;
    }

    @Override
    public void setPartOfSpeechTagger(PartOfSpeechTagger posTagger) {
        if (posTagger == null) {
            try {
                this.partOfSpeechTagger = new DefaultPartOfSpeechTagger();
            }
            catch (Exception exception) {}
        } else {
            this.partOfSpeechTagger = posTagger;
        }
        this.wordTokenizer = new DefaultWordTokenizer();
        this.sentenceSplitter = new DefaultSentenceSplitter();
        this.sentenceSplitter.setPartOfSpeechGuesser(this.partOfSpeechTagger.getPartOfSpeechGuesser());
        this.partOfSpeechTags = this.partOfSpeechTagger.getLexicon().getPartOfSpeechTags();
        this.setLexicon(this.partOfSpeechTagger.getLexicon());
    }

    public static <T extends AdornedWord> String namePositionToName(List<List<T>> sentences, NamePosition namePosition) {
        String result = "";
        List<T> sentence = sentences.get(namePosition.sentence);
        for (int i = namePosition.startingWord; i <= namePosition.endingWord; ++i) {
            result = result + sentence.get(i) + " ";
        }
        return result.trim();
    }

    @Override
    public abstract Set<String>[] findNames(String var1);

    @Override
    public abstract <T extends AdornedWord> Set<String>[] findNames(List<List<T>> var1);

    @Override
    public abstract <T extends AdornedWord> List<NamePosition>[] findNamePositions(List<List<T>> var1);

    @Override
    public void close() {
        this.names = null;
    }
}

