/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.lexicon;

import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.MutableInteger;
import edu.northwestern.at.utils.XCloneable;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

public class LexiconEntry
implements Serializable,
XCloneable {
    public String entry;
    public String standardEntry;
    public Map<String, String> lemmata;
    public int entryCount;
    public Map<String, MutableInteger> categoriesAndCounts;
    public String largestCategory;
    public int largestCategoryCount;

    public LexiconEntry(String entry, String standardEntry, int entryCount, Map<String, MutableInteger> categoriesAndCounts, Map<String, String> lemmata) {
        this.entry = entry;
        this.standardEntry = standardEntry;
        this.entryCount = entryCount;
        this.categoriesAndCounts = categoriesAndCounts;
        this.lemmata = lemmata;
        String largestCategory = "";
        boolean largestCategoryCount = false;
        this.determineLargestCategory();
    }

    public void determineLargestCategory() {
        for (String category : this.categoriesAndCounts.keySet()) {
            MutableInteger count = this.categoriesAndCounts.get(category);
            if (count.intValue() <= this.largestCategoryCount) continue;
            this.largestCategoryCount = count.intValue();
            this.largestCategory = category;
        }
    }

    public void updateCategoryAndCount(String category, int count) {
        MutableInteger currentCount = this.categoriesAndCounts.get(category);
        if (currentCount == null && count > 0) {
            this.categoriesAndCounts.put(category, new MutableInteger(count));
        } else {
            currentCount.setValue(currentCount.intValue() + count);
            if (currentCount.intValue() <= 0) {
                this.categoriesAndCounts.remove(category);
                this.determineLargestCategory();
            }
        }
    }

    public int getCategoryCount(String category) {
        int result = 0;
        if (this.categoriesAndCounts.get(category) != null) {
            result = this.categoriesAndCounts.get(category).intValue();
        }
        return result;
    }

    public String[] getCategories() {
        Set<String> categorySet = this.categoriesAndCounts.keySet();
        Object[] categories = categorySet.toArray(new String[categorySet.size()]);
        Arrays.sort(categories);
        return categories;
    }

    public void updateLemma(String category, String lemma) {
        if (lemma != null) {
            this.lemmata.put(category, lemma);
        }
    }

    public String getLemma(String category) {
        String result = this.lemmata.get(category);
        if (result == null || result.length() == 0) {
            result = "*";
        }
        return result;
    }

    public String[] getLexiconEntryData() {
        String[] result = new String[3 * this.categoriesAndCounts.keySet().size() + 2];
        result[0] = this.entry;
        result[1] = this.entryCount + "";
        result[2] = this.largestCategory;
        result[3] = this.getLemma(this.largestCategory);
        result[4] = this.largestCategoryCount + "";
        int k = 5;
        for (String category : this.categoriesAndCounts.keySet()) {
            if (category.equals(this.largestCategory)) continue;
            MutableInteger count = this.categoriesAndCounts.get(category);
            result[k++] = category;
            result[k++] = this.getLemma(category);
            result[k++] = count + "";
        }
        return result;
    }

    protected Map<String, MutableInteger> categoriesAndCountsClone() {
        Map<String, MutableInteger> result = MapFactory.createNewMap(this.categoriesAndCounts.size());
        for (String category : this.categoriesAndCounts.keySet()) {
            MutableInteger count = this.categoriesAndCounts.get(category);
            result.put(new String(category), new MutableInteger(count.intValue()));
        }
        return result;
    }

    protected Map<String, String> lemmataClone() {
        Map<String, String> result = MapFactory.createNewMap(this.lemmata.size());
        for (String key : this.lemmata.keySet()) {
            String data = this.lemmata.get(key);
            result.put(new String(key), new String(data));
        }
        return result;
    }

    @Override
    public Object clone() {
        return new LexiconEntry(this.entry, this.standardEntry, this.entryCount, this.categoriesAndCountsClone(), this.lemmataClone());
    }

    public LexiconEntry deepClone() {
        return (LexiconEntry)this.clone();
    }
}

