/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.lexicon;

import edu.northwestern.at.morphadorner.corpuslinguistics.outputter.PrintStreamAdornedWordOutputter;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.UnicodeReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class BrillLexicon
extends HashMap<String, List<String>> {
    public BrillLexicon(URL lexiconURL, String encoding) throws IOException {
        BufferedReader lexiconReader = encoding == null ? new BufferedReader(new UnicodeReader(lexiconURL.openStream())) : new BufferedReader(new UnicodeReader(lexiconURL.openStream(), encoding));
        String line = lexiconReader.readLine();
        String entry = "";
        while (line != null) {
            if ((line = line.trim()).length() > 0) {
                StringTokenizer tokens = new StringTokenizer(line);
                entry = tokens.nextToken();
                List<String> categories = ListFactory.createNewList();
                while (tokens.hasMoreTokens()) {
                    categories.add(tokens.nextToken());
                }
                this.put(entry, categories);
            }
            line = lexiconReader.readLine();
        }
    }

    public void saveToFile(String fileName, String encoding) throws IOException {
        PrintStreamAdornedWordOutputter outputter = new PrintStreamAdornedWordOutputter();
        outputter.createOutputFile(fileName, encoding, ' ');
        TreeSet sortedWordSet = new TreeSet(this.keySet());
        for (String word : sortedWordSet) {
            List entry = (List)this.get(word);
            outputter.outputWordAndAdornments(entry);
        }
        outputter.close();
    }
}

