/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.lemmatizer;

import edu.northwestern.at.morphadorner.corpuslinguistics.lemmatizer.LemmatizerRule;
import edu.northwestern.at.utils.StringUtils;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultLemmatizerRule
implements LemmatizerRule {
    protected String ruleText;
    protected String source;
    protected Pattern compiledSource;
    protected String replacement;
    protected static final Pattern VCRMatcher = Pattern.compile("([VCRA]+)");
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    protected int direction;
    protected int matchLength;
    protected boolean mustMatchDictionaryEntry;

    public DefaultLemmatizerRule(String ruleText) {
        this.ruleText = ruleText;
        this.direction = 1;
        this.source = "";
        this.replacement = "";
        this.mustMatchDictionaryEntry = false;
        StringTokenizer tokenizer = new StringTokenizer(ruleText, " \t");
        int nTokens = tokenizer.countTokens();
        if (nTokens > 0) {
            int i;
            String[] tokens = new String[nTokens];
            for (i = 0; i < nTokens; ++i) {
                tokens[i] = tokenizer.nextToken();
            }
            i = 0;
            char ch = tokens[0].charAt(0);
            switch (ch) {
                case '<': 
                case '>': {
                    this.direction = ch == '<' ? 0 : 1;
                    this.matchLength = StringUtils.stringToInt(tokens[0].substring(1), 0);
                    break;
                }
                case '+': {
                    this.mustMatchDictionaryEntry = true;
                    ++i;
                    break;
                }
            }
            int n = ++i;
            this.source = tokens[n];
            if (++i < nTokens) {
                this.replacement = tokens[i];
            }
            int replacementCount = 1;
            if (this.matchLength > 0) {
                if (this.direction == 1) {
                    this.source = "(..)" + this.source;
                    this.replacement = "$" + replacementCount + this.replacement;
                    ++replacementCount;
                } else {
                    --this.matchLength;
                    this.source = "^(.{1," + this.matchLength + "})" + this.source;
                    this.replacement = "$" + replacementCount + this.replacement;
                    ++replacementCount;
                }
            }
            Matcher m = VCRMatcher.matcher(this.source);
            if (this.source.indexOf("CC") >= 0) {
                this.source = StringUtils.replaceAll(this.source, "CC", "([^aeiouy])\\1");
                this.replacement = StringUtils.replaceFirst(this.replacement, "C", "$" + replacementCount);
            } else if (m.find()) {
                String phonolog = m.group(1);
                int start = m.start();
                int end = m.end();
                this.source = this.source.substring(0, start) + "(" + phonolog + ")" + this.source.substring(end);
                this.source = StringUtils.replaceAll(this.source, "V", "[aeiouy]");
                this.source = StringUtils.replaceAll(this.source, "C", "[^aeiouy]");
                this.source = StringUtils.replaceAll(this.source, "R", "r");
                this.source = StringUtils.replaceAll(this.source, "A", ".*");
                this.replacement = StringUtils.replaceFirst(this.replacement, phonolog, "$" + replacementCount);
                ++replacementCount;
            }
            this.source = this.source + "$";
            this.compiledSource = Pattern.compile(this.source);
        }
    }

    @Override
    public String apply(String s, Set<String> dictionary) {
        Matcher m;
        String result = s;
        if (this.compiledSource != null && (m = this.compiledSource.matcher(s)).find()) {
            result = m.replaceAll(this.replacement);
            if (this.mustMatchDictionaryEntry && dictionary != null && !dictionary.contains(result.toLowerCase())) {
                result = s;
            }
        }
        return result;
    }

    @Override
    public String apply(String s) {
        return this.apply(s, null);
    }

    public String toString() {
        return "s/" + this.source + "/" + this.replacement + "/";
    }
}

