/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.languagerecognizer;

import edu.northwestern.at.morphadorner.corpuslinguistics.languagerecognizer.DefaultLanguageRecognizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.languagerecognizer.LanguageRecognizer;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class LanguageRecognizerFactory {
    public static LanguageRecognizer newLanguageRecognizer() {
        String className = System.getProperty("languagerecognizer.class");
        if (className == null) {
            className = "DefaultLanguageRecognizer";
        }
        return LanguageRecognizerFactory.newLanguageRecognizer(className);
    }

    public static LanguageRecognizer newLanguageRecognizer(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("languagerecognizer.class");
        }
        if (className == null) {
            className = "DefaultLanguageRecognizer";
        }
        return LanguageRecognizerFactory.newLanguageRecognizer(className);
    }

    public static LanguageRecognizer newLanguageRecognizer(String className) {
        LanguageRecognizer languageRecognizer = null;
        try {
            languageRecognizer = (LanguageRecognizer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(LanguageRecognizerFactory.class.getName()) + "." + className;
            try {
                languageRecognizer = (LanguageRecognizer)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create language recognizer of class " + fixedClassName + ", using default.");
                try {
                    languageRecognizer = new DefaultLanguageRecognizer();
                }
                catch (Exception e3) {
                    System.err.println("Unable to create default language recognizer.");
                }
            }
        }
        return languageRecognizer;
    }
}

