/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.languagerecognizer;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.DetectorFactory;
import com.cybozu.labs.langdetect.LangDetectException;
import com.cybozu.labs.langdetect.Language;
import edu.northwestern.at.morphadorner.corpuslinguistics.languagerecognizer.AbstractLanguageRecognizer;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.ScoredString;
import java.util.ArrayList;
import java.util.List;

public class CybozuLabsLanguageRecognizer
extends AbstractLanguageRecognizer {
    public CybozuLabsLanguageRecognizer() throws LangDetectException {
        DetectorFactory.setSeed(0L);
    }

    public CybozuLabsLanguageRecognizer(List<String> languages) throws LangDetectException {
        DetectorFactory.loadProfilesByName(languages);
        DetectorFactory.setSeed(0L);
    }

    @Override
    public ScoredString[] recognizeLanguage(String text) {
        ScoredString[] result = null;
        List<ScoredString> resultList = ListFactory.createNewList();
        try {
            Detector detector = DetectorFactory.create();
            detector.append(text);
            ArrayList<Language> languages = detector.getProbabilities();
            for (int i = 0; i < languages.size(); ++i) {
                Language language = (Language)languages.get(i);
                resultList.add(new ScoredString(language.lang, language.prob));
            }
            result = resultList.toArray(new ScoredString[resultList.size()]);
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public List<String> getAvailableLanguageProfileNames() {
        return DetectorFactory.getLangList();
    }

    public static List<String> getDefaultLanguageProfileNames() {
        return DetectorFactory.getLangList();
    }
}

