/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.inputter;

import edu.northwestern.at.morphadorner.corpuslinguistics.inputter.GapFixer;
import edu.northwestern.at.morphadorner.corpuslinguistics.inputter.OrigFixer;
import edu.northwestern.at.morphadorner.corpuslinguistics.inputter.TextInputter;
import edu.northwestern.at.utils.DirUtils;
import edu.northwestern.at.utils.FileUtils;
import edu.northwestern.at.utils.IsCloseableObject;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.PatternReplacer;
import edu.northwestern.at.utils.UnicodeReader;
import edu.northwestern.at.utils.WhitespaceTrimmingBufferedReader;
import edu.northwestern.at.utils.xml.JDOMUtils;
import edu.northwestern.at.utils.xml.XMLTextReplacer;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jdom2.Content;
import org.jdom2.DocType;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.SAXException;

public class XMLTextInputter
extends IsCloseableObject
implements TextInputter {
    protected Map<String, Object> segmentMap = new TreeMap<String, Object>();
    protected int textID = 0;
    protected List<String> segmentNames = ListFactory.createNewList();
    protected String encoding = "utf-8";
    protected boolean splitText = true;
    protected boolean fixGaps = true;
    protected boolean fixOrigs = true;
    protected boolean fixSplitWords = false;
    protected List<PatternReplacer> fixSplitWordsPatternReplacers = null;
    protected final String teiHeaderPattern = "tei|tei\\.2|TEI|TEI\\.2";
    protected Document document;
    protected boolean storesSegmentFiles = false;

    public XMLTextInputter() {
        this.segmentMap = new TreeMap<String, Object>();
    }

    protected void doLoadDocument(Document document, String schemaURI, String docPath) throws JDOMException, IOException, URISyntaxException, SAXException {
        URI uri;
        String uriScheme;
        DocType docType;
        Element etsNode;
        if (document.getDocType() == null && schemaURI != null && schemaURI.length() > 0) {
            JDOMUtils.validateDocument(document, schemaURI);
        }
        Element teiNode = (etsNode = document.getRootElement()).getName().matches("tei|tei\\.2|TEI|TEI\\.2") ? etsNode : this.findChild(etsNode, "tei|tei\\.2|TEI|TEI\\.2");
        Element eeboNode = etsNode.getChild("eebo");
        if (eeboNode == null) {
            eeboNode = etsNode.getChild("EEBO");
        }
        Element groupTextRoot = null;
        if (eeboNode != null && (groupTextRoot = eeboNode.getChild("group")) == null) {
            groupTextRoot = eeboNode.getChild("GROUP");
        }
        Element textParent = null;
        Element textNode = null;
        if (groupTextRoot != null) {
            textParent = eeboNode;
            textNode = groupTextRoot;
        } else {
            textParent = eeboNode;
            if (textParent == null) {
                textParent = teiNode;
            }
            textNode = this.findChild(textParent, "text|TEXT");
        }
        if (this.fixGaps) {
            GapFixer.fixGaps(document);
        }
        if (this.fixOrigs) {
            OrigFixer.fixOrigs(document);
        }
        this.writeChildren(textNode, "text", this.splitText);
        Format format = Format.getRawFormat();
        XMLOutputter xmlOut = new XMLOutputter(format);
        this.putSegment("text", xmlOut.outputString(textNode));
        textParent.removeContent((Content)textNode);
        this.putSegment("head", xmlOut.outputString(document));
        Iterator<String> iterator = this.segmentMap.keySet().iterator();
        while (iterator.hasNext()) {
            this.segmentNames.add(iterator.next());
        }
        if (this.encoding != null && this.encoding.length() > 0) {
            this.encoding = this.encoding;
        }
        if ((docType = document.getDocType()) != null && ((uriScheme = (uri = new URI(docType.getSystemID())).getScheme()) == null || uriScheme.equalsIgnoreCase("file"))) {
            String uriPath = uri.getPath();
            File sourceFile = new File(uriPath);
            if (!sourceFile.isAbsolute()) {
                sourceFile = new File(new File(docPath).getParent(), sourceFile.getPath());
            }
            File destFile = new File(DirUtils.getTemporaryFilesDirectory(), sourceFile.getName());
            FileUtils.copyFile(sourceFile.getAbsolutePath(), destFile.getAbsolutePath());
            destFile.deleteOnExit();
        }
    }

    protected void doLoadText(URL url, String encoding, String schemaURI) throws JDOMException, IOException, URISyntaxException, SAXException {
        SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        WhitespaceTrimmingBufferedReader bufferedReader = new WhitespaceTrimmingBufferedReader(new UnicodeReader(url.openStream(), encoding));
        this.document = builder.build((Reader)bufferedReader);
        bufferedReader.close();
        this.doLoadDocument(this.document, schemaURI, url.getPath());
    }

    public Element findChild(Element parent, String namePat) {
        Element result = null;
        if (parent != null) {
            List children = parent.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                Element child = (Element)children.get(i);
                if (!child.getName().matches(namePat)) continue;
                result = child;
                break;
            }
        }
        return result;
    }

    @Override
    public void loadText(URL url, String encoding) throws Exception {
        try {
            this.doLoadText(url, encoding, null);
        }
        catch (JDOMException e) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    @Override
    public void loadText(URL url, String encoding, String xmlSchemaURI) throws Exception {
        try {
            this.doLoadText(url, encoding, xmlSchemaURI);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void loadText(String str) throws Exception {
        this.loadText(str, "");
    }

    @Override
    public void loadText(String str, String xmlSchemaURI) throws Exception {
        SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        WhitespaceTrimmingBufferedReader bufferedReader = new WhitespaceTrimmingBufferedReader(new StringReader(str));
        this.document = builder.build((Reader)bufferedReader);
        bufferedReader.close();
        this.doLoadDocument(this.document, xmlSchemaURI, DirUtils.getTemporaryFilesDirectory());
    }

    @Override
    public int getSegmentCount() {
        return this.segmentNames.size();
    }

    @Override
    public String getSegmentName(int segmentNumber) {
        String result = null;
        if (segmentNumber >= 0 && segmentNumber < this.segmentNames.size()) {
            result = this.segmentNames.get(segmentNumber);
        }
        return result;
    }

    @Override
    public String getSegmentText(int segmentNumber) {
        String result = null;
        if (segmentNumber >= 0 && segmentNumber < this.segmentNames.size()) {
            result = "";
            try {
                result = this.getSegment(this.segmentNames.get(segmentNumber));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public String getSegmentText(String segmentName) {
        String result = null;
        if (segmentName != null && this.segmentMap.containsKey(segmentName)) {
            result = this.getSegment(segmentName);
        }
        return result;
    }

    @Override
    public void setSegmentText(int segmentNumber, String segmentText) {
        if (segmentNumber >= 0 && segmentNumber < this.segmentNames.size()) {
            this.putSegment(this.segmentNames.get(segmentNumber), segmentText);
        }
    }

    @Override
    public void setSegmentText(String segmentName, String segmentText) {
        if (segmentName != null && this.segmentMap.containsKey(segmentName)) {
            this.putSegment(segmentName, segmentText);
        }
    }

    @Override
    public void setSegmentText(int segmentNumber, File segmentTextFile) {
        try {
            this.setSegmentText(segmentNumber, FileUtils.readTextFile(segmentTextFile, "utf-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setSegmentText(String segmentName, File segmentTextFile) {
        try {
            this.setSegmentText(segmentName, FileUtils.readTextFile(segmentTextFile, "utf-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int getNextTextID() {
        return ++this.textID;
    }

    protected void writeChildren(Element element, String baseFileName, boolean splitText) {
        if (element == null) {
            return;
        }
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setGroupingUsed(false);
        formatter.setMinimumIntegerDigits(5);
        Format format = Format.getRawFormat();
        XMLOutputter xmlOut = new XMLOutputter(format);
        List textChildren = element.getChildren();
        while (textChildren.size() > 0) {
            Element child = (Element)textChildren.get(0);
            int nextID = this.getNextTextID();
            if (splitText && child.getName().equalsIgnoreCase("body")) {
                this.writeChildren(child, baseFileName, splitText);
            }
            String segmentText = xmlOut.outputString(child);
            if (this.fixSplitWords) {
                segmentText = XMLTextReplacer.performReplacements(segmentText, this.fixSplitWordsPatternReplacers);
            }
            this.putSegment(baseFileName + formatter.format(nextID), segmentText);
            element.removeContent((Content)child);
        }
    }

    protected String getSegment(String segmentName) {
        String result = "";
        if (this.segmentMap.containsKey(segmentName)) {
            result = (String)this.segmentMap.get(segmentName);
        }
        return result;
    }

    protected void putSegment(String segmentName, String segmentText) {
        this.segmentMap.put(segmentName, segmentText.replaceAll("[\r\n]", " "));
    }

    @Override
    public void enableGapFixer(boolean fixGaps) {
        this.fixGaps = fixGaps;
    }

    @Override
    public void enableOrigFixer(boolean fixOrigs) {
        this.fixOrigs = fixOrigs;
    }

    @Override
    public void enableSplitWordsFixer(boolean fixSplitWords, List<PatternReplacer> patternReplacers) {
        this.fixSplitWords = fixSplitWords && patternReplacers != null && patternReplacers.size() > 0;
        this.fixSplitWordsPatternReplacers = patternReplacers;
    }

    @Override
    public boolean usesSegmentFiles() {
        return this.storesSegmentFiles;
    }

    @Override
    public void close() {
        this.segmentMap.clear();
        this.segmentNames.clear();
        this.segmentMap = null;
        this.segmentNames = null;
        this.document = null;
        super.close();
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

