/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.inflector.conjugator;

import edu.northwestern.at.morphadorner.corpuslinguistics.inflector.Person;
import edu.northwestern.at.morphadorner.corpuslinguistics.inflector.VerbTense;
import edu.northwestern.at.morphadorner.corpuslinguistics.inflector.conjugator.Conjugator;
import edu.northwestern.at.utils.Map3D;
import edu.northwestern.at.utils.Map3DUtils;
import edu.northwestern.at.utils.PatternReplacer;
import edu.northwestern.at.utils.SetUtils;
import java.util.Set;

public class EnglishConjugator
implements Conjugator {
    protected static Set<String> doublingVerbs = null;
    protected static final String doublingVerbsPath = "resources/doublingverbs.txt";
    protected static final PatternReplacer presentParticiplePattern1 = new PatternReplacer("(.[bcdfghjklmnpqrstvwxyz])eing$", "$1ing");
    protected static final PatternReplacer presentParticiplePattern2 = new PatternReplacer("ieing$", "ying");
    protected Map3D<String, String, String, String> irregularVerbs = null;
    protected static final String irregularVerbsPath = "resources/irregularverbs.txt";

    public EnglishConjugator() {
        if (doublingVerbs == null) {
            try {
                doublingVerbs = SetUtils.loadSet(EnglishConjugator.class.getResource(doublingVerbsPath), "utf-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.irregularVerbs == null) {
            try {
                this.irregularVerbs = Map3DUtils.loadMap3D(EnglishConjugator.class.getResource(irregularVerbsPath), "\t", "", "utf-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String conjugate(String infinitive, VerbTense tense, Person person) {
        String verb = infinitive.toLowerCase();
        String result = this.irregularVerbs.get(verb, person.toString(), tense.toString());
        if (result == null) {
            result = this.irregularVerbs.get(verb, "*", tense.toString());
        }
        if (result != null) {
            return result;
        }
        result = verb;
        switch (tense) {
            case PRESENT: {
                if (person != Person.THIRD_PERSON_SINGULAR) break;
                if (result.matches(".*(ch|s|sh|x|z)$")) {
                    result = result + "es";
                    break;
                }
                if (result.matches(".*[^aeiou]y")) {
                    result = result.substring(0, result.length() - 1) + "ies";
                    break;
                }
                result = result + "s";
                break;
            }
            case PRESENT_PARTICIPLE: {
                if (result.matches(".*[^aeiou]e")) {
                    result = result.substring(0, result.length() - 1);
                } else if (result.endsWith("ie")) {
                    result = result.substring(0, result.length() - 2) + "y";
                } else if (result.matches(".*[aou]e")) {
                    result = result.substring(0, result.length() - 1);
                } else if (doublingVerbs.contains(verb)) {
                    result = result + result.substring(result.length() - 1, result.length());
                }
                result = result + "ing";
                break;
            }
            case PAST: 
            case PAST_PARTICIPLE: {
                if (result.endsWith("e")) {
                    result = result + "d";
                    break;
                }
                if (result.matches(".*[^aeiou]y")) {
                    result = result.substring(0, result.length() - 1) + "ied";
                    break;
                }
                if (doublingVerbs.contains(verb)) {
                    result = result + result.substring(result.length() - 1, result.length());
                }
                result = result + "ed";
            }
        }
        return result;
    }
}

