/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.hyphenator;

import edu.northwestern.at.morphadorner.corpuslinguistics.hyphenator.DefaultHyphenator;
import edu.northwestern.at.morphadorner.corpuslinguistics.hyphenator.Hyphenator;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class HyphenatorFactory {
    public static Hyphenator newHyphenator() {
        String className = System.getProperty("hyphenator.class");
        if (className == null) {
            className = "DefaultHyphenator";
        }
        return HyphenatorFactory.newHyphenator(className);
    }

    public static Hyphenator newHyphenator(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("hyphenator.class");
        }
        if (className == null) {
            className = "DefaultHyphenator";
        }
        return HyphenatorFactory.newHyphenator(className);
    }

    public static Hyphenator newHyphenator(String className) {
        Hyphenator hyphenator = null;
        try {
            hyphenator = (Hyphenator)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(HyphenatorFactory.class.getName()) + "." + className;
            try {
                hyphenator = (Hyphenator)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create hyphenator of class " + fixedClassName + ", using default.");
                try {
                    hyphenator = new DefaultHyphenator();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return hyphenator;
    }
}

