/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.contractionexpander;

import edu.northwestern.at.morphadorner.corpuslinguistics.contractionexpander.ContractionExpander;
import edu.northwestern.at.morphadorner.corpuslinguistics.contractionexpander.DefaultContractionExpander;
import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.UTF8Properties;

public class ContractionExpanderFactory {
    public static ContractionExpander newContractionExpander() {
        String className = System.getProperty("contractionExpander.class");
        if (className == null) {
            className = "DefaultContractionExpander";
        }
        return ContractionExpanderFactory.newContractionExpander(className);
    }

    public static ContractionExpander newContractionExpander(UTF8Properties properties) {
        String className = null;
        if (properties != null) {
            className = properties.getProperty("contractionExpander.class");
        }
        if (className == null) {
            className = "DefaultContractionExpander";
        }
        return ContractionExpanderFactory.newContractionExpander(className);
    }

    public static ContractionExpander newContractionExpander(String className) {
        ContractionExpander contractionExpander = null;
        try {
            contractionExpander = (ContractionExpander)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(ContractionExpanderFactory.class.getName()) + "." + className;
            try {
                contractionExpander = (ContractionExpander)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create contraction expander of class " + fixedClassName + ", using default.");
                try {
                    contractionExpander = new DefaultContractionExpander();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return contractionExpander;
    }
}

