/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.contractionexpander;

import edu.northwestern.at.morphadorner.corpuslinguistics.contractionexpander.ContractionExpander;
import edu.northwestern.at.utils.IsCloseableObject;
import edu.northwestern.at.utils.TaggedStrings;
import edu.northwestern.at.utils.TaggedStringsMap;
import edu.northwestern.at.utils.logger.DummyLogger;
import edu.northwestern.at.utils.logger.Logger;
import edu.northwestern.at.utils.logger.UsesLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public abstract class AbstractContractionExpander
extends IsCloseableObject
implements ContractionExpander,
UsesLogger {
    protected TaggedStrings contractedSpellings = new TaggedStringsMap();
    protected Logger logger = new DummyLogger();

    protected void loadContractedSpellings(Reader reader) throws IOException {
        String line = null;
        String contraction = "";
        String expanded = "";
        String[] tokens = new String[2];
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((line = bufferedReader.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#' || (tokens = line.split("\t")).length < 2) continue;
            this.contractedSpellings.putTag(tokens[0], tokens[1]);
        }
        bufferedReader.close();
    }

    @Override
    public String expandContraction(String spelling) {
        String result = spelling;
        if (this.contractedSpellings.containsString(spelling.toLowerCase())) {
            result = this.contractedSpellings.getTag(spelling.toLowerCase());
        }
        return result;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

