/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.apostokens;

import edu.northwestern.at.utils.SetFactory;
import edu.northwestern.at.utils.SetUtils;
import java.io.IOException;
import java.util.Set;

public class AposTokens {
    protected Set<String> aposTokens = null;
    protected static final String defaultAposTokensFileName = "resources/en-apostokens.txt";

    public AposTokens() {
        this.aposTokens = AposTokens.loadAposTokensFromResource("en");
    }

    public AposTokens(String langCode) {
        this.aposTokens = AposTokens.loadAposTokensFromResource(langCode);
    }

    public static Set<String> loadAposTokensFromResource(String langCode) {
        Set<String> result = SetFactory.createNewSet();
        try {
            SetUtils.loadIntoSet(result, AposTokens.class.getResource("resources/" + langCode + "-apostokens.txt"), "utf-8");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public boolean loadAposTokens(String aposTokensURL) {
        boolean result = false;
        if (this.aposTokens == null) {
            this.aposTokens = SetFactory.createNewSet();
        }
        try {
            this.aposTokens = SetUtils.loadSet(aposTokensURL, "utf-8");
            result = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public boolean isKnownAposToken(String str) {
        return this.aposTokens.contains(str.toLowerCase());
    }

    public int getAposTokensCount() {
        int result = 0;
        if (this.aposTokens != null) {
            result = this.aposTokens.size();
        }
        return result;
    }

    public Set<String> getAposTokens() {
        return this.aposTokens;
    }
}

