/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.corpuslinguistics.adornedword;

import edu.northwestern.at.morphadorner.corpuslinguistics.adornedword.AdornedWord;
import edu.northwestern.at.utils.XCloneable;
import java.io.Serializable;

public class BaseAdornedWord
implements AdornedWord,
XCloneable,
Comparable,
Serializable {
    protected String token;
    protected String spelling;
    protected String standardSpelling;
    protected String lemmata;
    protected String partsOfSpeech;

    public BaseAdornedWord() {
        this.token = "";
        this.spelling = "";
        this.standardSpelling = "";
        this.lemmata = "";
        this.partsOfSpeech = "";
    }

    public BaseAdornedWord(String spelling) {
        this.token = spelling;
        this.spelling = spelling;
        this.standardSpelling = spelling;
        this.lemmata = "";
        this.partsOfSpeech = "";
    }

    public BaseAdornedWord(String spelling, String partsOfSpeech) {
        this.token = spelling;
        this.spelling = spelling;
        this.standardSpelling = spelling;
        this.lemmata = "";
        this.partsOfSpeech = partsOfSpeech;
    }

    public BaseAdornedWord(String token, String spelling, String partsOfSpeech) {
        this.token = token;
        this.spelling = spelling;
        this.standardSpelling = spelling;
        this.lemmata = "";
        this.partsOfSpeech = partsOfSpeech;
    }

    public BaseAdornedWord(String token, String spelling, String standardSpelling, String lemmata, String partsOfSpeech) {
        this.token = token;
        this.spelling = spelling;
        this.standardSpelling = standardSpelling;
        this.lemmata = lemmata;
        this.partsOfSpeech = partsOfSpeech;
    }

    public BaseAdornedWord(AdornedWord adornedWord) {
        this.token = adornedWord.getToken();
        this.spelling = adornedWord.getSpelling();
        this.standardSpelling = adornedWord.getStandardSpelling();
        this.lemmata = adornedWord.getLemmata();
        this.partsOfSpeech = adornedWord.getPartsOfSpeech();
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public String getSpelling() {
        return this.spelling;
    }

    @Override
    public void setSpelling(String spelling) {
        this.spelling = spelling;
    }

    @Override
    public String getStandardSpelling() {
        return this.standardSpelling;
    }

    @Override
    public void setStandardSpelling(String standardSpelling) {
        this.standardSpelling = standardSpelling;
    }

    @Override
    public String getLemmata() {
        return this.lemmata;
    }

    @Override
    public void setLemmata(String lemmata) {
        this.lemmata = lemmata;
    }

    @Override
    public String getPartsOfSpeech() {
        return this.partsOfSpeech;
    }

    @Override
    public void setPartsOfSpeech(String partsOfSpeech) {
        this.partsOfSpeech = partsOfSpeech;
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object instanceof BaseAdornedWord) {
            AdornedWord otherAdornedWord = (AdornedWord)object;
            result = this.spelling.equals(otherAdornedWord.getSpelling()) && this.lemmata.equals(otherAdornedWord.getLemmata()) && this.partsOfSpeech.equals(otherAdornedWord.getPartsOfSpeech());
        }
        return result;
    }

    public int compareTo(Object object) {
        int result = 0;
        if (object == null || !(object instanceof AdornedWord)) {
            result = Integer.MIN_VALUE;
        } else {
            AdornedWord otherAdornedWord = (AdornedWord)object;
            result = this.spelling.compareTo(otherAdornedWord.getSpelling());
            if (result == 0) {
                result = this.lemmata.compareTo(otherAdornedWord.getLemmata());
            }
            if (result == 0) {
                result = this.partsOfSpeech.compareTo(otherAdornedWord.getPartsOfSpeech());
            }
        }
        return result;
    }

    public int hashCode() {
        return this.spelling.hashCode() ^ this.lemmata.hashCode() ^ this.partsOfSpeech.hashCode();
    }

    public String toString() {
        return this.spelling;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

