/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner;

import edu.northwestern.at.morphadorner.MorphAdornerSettings;
import edu.northwestern.at.morphadorner.SentenceAndWordNumber;
import edu.northwestern.at.morphadorner.WordAttributeNames;
import edu.northwestern.at.morphadorner.WordAttributePatterns;
import edu.northwestern.at.utils.SortedArrayList;
import edu.northwestern.at.utils.UnicodeReader;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Formatter;

public class SentenceNumberAdder {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static String milestoneFormat = "%s<milestone unit=\"sentence\" n=\"%s\" position=\"%s\"/>";
    protected static String milestoneWithPathFormat = "%s<milestone unit=\"sentence\" n=\"%s\" position=\"%s\" " + WordAttributeNames.p + "=\"%s\"/>";

    public SentenceNumberAdder(String inputFileName, String outputFileName, SortedArrayList<SentenceAndWordNumber> sortedWords, MorphAdornerSettings morphAdornerSettings) {
        try {
            UnicodeReader streamReader = new UnicodeReader(new FileInputStream(new File(inputFileName)), "utf-8");
            BufferedReader in = new BufferedReader(streamReader);
            FileOutputStream outputStream = new FileOutputStream(outputFileName, false);
            BufferedOutputStream bufferedStream = new BufferedOutputStream(outputStream);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bufferedStream, "utf-8");
            PrintWriter printWriter = new PrintWriter(writer);
            String line = in.readLine();
            boolean needLine = true;
            int wIndex = -1;
            SentenceAndWordNumber lookupSWN = new SentenceAndWordNumber("", 0, "", false);
            int totalWords = 0;
            int lookedUpWords = 0;
            while (line != null) {
                if (line.trim().length() > 0) {
                    int wPos = line.indexOf("<w ");
                    if (wPos >= 0) {
                        SentenceAndWordNumber swn;
                        ++totalWords;
                        String[] wValues = WordAttributePatterns.wReplacer.matchGroups(line);
                        String[] idValues = WordAttributePatterns.idReplacer.matchGroups(wValues[2]);
                        String id = idValues[2];
                        String[] pathValues = WordAttributePatterns.pathReplacer.matchGroups(wValues[2]);
                        String path = "";
                        if (pathValues != null) {
                            path = pathValues[2];
                        }
                        String wordText = wValues[3];
                        if (!(swn = (SentenceAndWordNumber)sortedWords.get(++wIndex)).getID().equals(id)) {
                            lookupSWN.setID(id);
                            wIndex = sortedWords.indexOf(lookupSWN);
                            swn = (SentenceAndWordNumber)sortedWords.get(wIndex);
                            ++lookedUpWords;
                        }
                        int sentenceNumber = swn.getSentenceNumber();
                        int wordNumber = swn.getWordNumber();
                        boolean isEOS = swn.getEOS();
                        boolean isFirstPart = swn.isFirstPart();
                        boolean isLastPart = swn.isLastPart();
                        if (wordNumber == 1 && isFirstPart && morphAdornerSettings.outputSentenceBoundaryMilestones) {
                            printWriter.println(this.makeMilestone("start", sentenceNumber, wValues[1], path));
                        }
                        StringBuilder sb = new StringBuilder();
                        sb.append(wValues[1]);
                        sb.append("<w ");
                        sb.append(wValues[2]);
                        if (morphAdornerSettings.outputSentenceNumber) {
                            sb.append(" ");
                            sb.append(morphAdornerSettings.outputSentenceNumberAttribute);
                            sb.append("=\"");
                            sb.append(sentenceNumber);
                            sb.append("\"");
                        }
                        if (morphAdornerSettings.outputWordNumber) {
                            sb.append(" ");
                            sb.append(morphAdornerSettings.outputWordNumberAttribute);
                            sb.append("=\"");
                            sb.append(wordNumber);
                            sb.append("\"");
                        }
                        sb.append(">");
                        sb.append(wValues[3]);
                        sb.append("</w>");
                        sb.append(wValues[4]);
                        printWriter.println(sb);
                        if (isEOS && isLastPart && morphAdornerSettings.outputSentenceBoundaryMilestones) {
                            line = in.readLine();
                            while (line != null && line.trim().startsWith("<c>")) {
                                printWriter.println(line);
                                line = in.readLine();
                            }
                            needLine = false;
                            printWriter.println(this.makeMilestone("end", sentenceNumber, wValues[1], path));
                        }
                    } else {
                        printWriter.println(line);
                    }
                }
                if (needLine) {
                    line = in.readLine();
                }
                needLine = true;
            }
            in.close();
            printWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String makeMilestone(String position, int number, String indent, String path) {
        int lastSlash;
        String sentencePath = "";
        if (path != null && path.length() > 0 && (lastSlash = (sentencePath = path).lastIndexOf("\\")) >= 0) {
            sentencePath = sentencePath.substring(0, lastSlash);
        }
        StringBuilder sb = new StringBuilder();
        if (sentencePath.length() > 0) {
            new Formatter(sb).format(milestoneWithPathFormat, indent, number + "", position, sentencePath);
        } else {
            new Formatter(sb).format(milestoneFormat, indent, number + "", position);
        }
        return sb.toString();
    }
}

