/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner;

import edu.northwestern.at.morphadorner.PendingElement;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.QueueStack;
import edu.northwestern.at.utils.SetFactory;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.xml.ExtendedXMLFilterImpl;
import java.util.List;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class PseudoPageAdderFilter
extends ExtendedXMLFilterImpl {
    protected List<String> tagList = ListFactory.createNewList();
    protected int pseudoPageSize = 300;
    protected int pseudoPageCount = 0;
    protected int pseudoPageWordCount = 0;
    protected boolean pseudoPageStarted = false;
    protected QueueStack<String> divStack = new QueueStack();
    protected QueueStack<Attributes> attrStack = new QueueStack();
    protected Set<String> pseudoPageContainerDivTypes = SetFactory.createNewSet();

    public PseudoPageAdderFilter(XMLReader reader, int pseudoPageSize, String pageEndingDivTypes) {
        super(reader);
        this.pseudoPageSize = pseudoPageSize;
        String[] divTypes = StringUtils.makeTokenArray(pageEndingDivTypes);
        for (int i = 0; i < divTypes.length; ++i) {
            this.pseudoPageContainerDivTypes.add(divTypes[i].toLowerCase());
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        boolean emitElement = true;
        AttributesImpl newAtts = new AttributesImpl(atts);
        boolean isW = qName.equals("w");
        boolean isLastWordPart = false;
        String p = atts.getValue("p");
        if (isW) {
            String part = atts.getValue("part");
            if (part == null) {
                part = "N";
            }
            boolean bl = isLastWordPart = part.equals("N") || part.equals("F");
            if (isLastWordPart) {
                if (this.pseudoPageWordCount == 0 && !this.pseudoPageStarted) {
                    if (p != null && p.length() > 0) {
                        int bsPos = p.lastIndexOf("\\");
                        if (bsPos > 0) {
                            p = p.substring(0, bsPos);
                        }
                        p = p + "\\milestone[" + (this.pseudoPageCount + 1) + "]";
                    }
                    this.emitPseudoPageElement(this.createPseudoPageElement(uri, false, true, p));
                }
                ++this.pseudoPageWordCount;
            }
        } else if (qName.equalsIgnoreCase("div")) {
            String divType = atts.getValue("type");
            if (divType == null || divType.length() == 0) {
                divType = "*div";
            }
            this.divStack.push(divType.toLowerCase());
        } else if (qName.equalsIgnoreCase("c")) {
            this.removeAttribute(newAtts, "part");
        } else if (qName.equalsIgnoreCase("milestone")) {
            String unit = newAtts.getValue("type");
            boolean bl = emitElement = unit != null && !unit.equals("pseudopage");
        }
        if (emitElement) {
            super.startElement(uri, localName, qName, newAtts);
        }
        this.attrStack.push(newAtts);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        super.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        boolean emitElement = true;
        Attributes attrs = new AttributesImpl();
        if (!this.attrStack.isEmpty()) {
            attrs = this.attrStack.pop();
        }
        boolean removedDiv = false;
        String removedDivType = "";
        boolean isW = false;
        boolean isLastWordPart = false;
        if (qName.equals("div")) {
            if (!this.divStack.isEmpty()) {
                removedDivType = this.divStack.pop();
                removedDiv = true;
            }
        } else if (qName.equals("w")) {
            isW = true;
            String part = attrs.getValue("part");
            isLastWordPart = part == null || part.equals("N") || part.equals("F");
        } else if (qName.equalsIgnoreCase("milestone")) {
            String unit = attrs.getValue("type");
            boolean bl = emitElement = unit != null && !unit.equals("pseudopage");
        }
        if (emitElement) {
            super.endElement(uri, localName, qName);
        }
        String p = null;
        if (removedDiv && this.pseudoPageContainerDivTypes.contains(removedDivType)) {
            if (p != null && p.length() > 0) {
                int bsPos = p.lastIndexOf("\\");
                if (bsPos > 0) {
                    p = p.substring(0, bsPos);
                }
                p = p + "\\milestone[" + (this.pseudoPageCount + 1) + "]";
            }
            this.emitPseudoPageElement(this.createPseudoPageElement(uri, false, false, p));
        } else if (isW && isLastWordPart && this.pseudoPageWordCount >= this.pseudoPageSize) {
            if (p != null && p.length() > 0) {
                int bsPos = p.lastIndexOf("\\");
                if (bsPos > 0) {
                    p = p.substring(0, bsPos);
                }
                p = p + "\\milestone[" + (this.pseudoPageCount + 1) + "]";
            }
            this.emitPseudoPageElement(this.createPseudoPageElement(uri, false, false, p));
        }
    }

    public PendingElement createPseudoPageElement(String uri, boolean forcedEmit, boolean start, String path) {
        if (start) {
            ++this.pseudoPageCount;
            this.pseudoPageStarted = true;
        } else {
            this.pseudoPageStarted = false;
        }
        this.pseudoPageWordCount = 0;
        AttributesImpl pageAttributes = new AttributesImpl();
        this.setAttributeValue(pageAttributes, "unit", "pseudopage");
        this.setAttributeValue(pageAttributes, "n", this.pseudoPageCount + "");
        this.setAttributeValue(pageAttributes, "position", start ? "start" : "end");
        if (path != null && path.length() > 0) {
            this.setAttributeValue(pageAttributes, "p", path);
        }
        return new PendingElement(uri, "milestone", "milestone", pageAttributes);
    }

    public void emitPseudoPageElement(PendingElement pseudoPageElement) {
        if (pseudoPageElement != null) {
            try {
                super.startElement(pseudoPageElement.getURI(), pseudoPageElement.getLocalName(), pseudoPageElement.getQName(), pseudoPageElement.getAttributes());
                super.endElement(pseudoPageElement.getURI(), pseudoPageElement.getLocalName(), pseudoPageElement.getQName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

