/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner;

import edu.northwestern.at.morphadorner.MorphAdornerLogger;
import edu.northwestern.at.morphadorner.WordAttributeNames;
import edu.northwestern.at.morphadorner.xgtagger.XGMisc;
import edu.northwestern.at.morphadorner.xgtagger.XGOptions;
import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.PatternReplacer;
import edu.northwestern.at.utils.URLUtils;
import edu.northwestern.at.utils.UTF8Properties;
import edu.northwestern.at.utils.UTF8PropertyUtils;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class MorphAdornerSettings
implements Serializable {
    protected ResourceBundle resourceBundle = null;
    protected static String resourceName = "edu.northwestern.at.morphadorner.resources.ma";
    public String programTitle;
    public String programVersion;
    public String programBanner;
    public MorphAdornerLogger morphAdornerLogger = null;
    public UTF8Properties properties;
    public XGOptions xgOptions = new XGOptions();
    public boolean debug = false;
    protected boolean initialized = false;
    public String outputDirectoryName = "adorned/";
    protected String wordLexiconURLString = null;
    public URL wordLexiconURL = null;
    protected String suffixLexiconURLString = null;
    public URL suffixLexiconURL = null;
    protected String contextRulesURLString = null;
    public URL contextRulesURL = null;
    protected String lexicalRulesURLString = null;
    public URL lexicalRulesURL = null;
    protected String spellingsURLString = null;
    public URL spellingsURL = null;
    protected String[] alternateSpellingsURLStrings = null;
    public URL[] alternateSpellingsURLs = null;
    protected String[] alternateSpellingsByWordClassURLStrings = null;
    public URL[] alternateSpellingsByWordClassURLs = null;
    protected String transitionMatrixURLString = null;
    public URL transitionMatrixURL = null;
    protected String defaultPropertiesURLString = "morphadorner.properties";
    protected String propertiesURLString = null;
    public URL propertiesURL = null;
    public String[] fileNames = null;
    public boolean outputSentenceNumber = false;
    public String outputSentenceNumberAttribute = WordAttributeNames.sn;
    public String outputWordOrdinalAttribute = WordAttributeNames.ord;
    public boolean outputWordOrdinal = false;
    public boolean outputWordNumber = false;
    public String outputWordNumberAttribute = WordAttributeNames.wn;
    public boolean outputRunningWordNumbers = false;
    public boolean outputSpelling = true;
    public String outputSpellingAttribute = WordAttributeNames.spe;
    public boolean outputOriginalToken = true;
    public String outputOriginalTokenAttribute = WordAttributeNames.tok;
    public boolean outputPartOfSpeech = true;
    public String outputPartOfSpeechAttribute = WordAttributeNames.pos;
    public boolean outputLemma = true;
    public String outputLemmaAttribute = WordAttributeNames.lem;
    public boolean outputStandardSpelling = true;
    public String outputStandardSpellingAttribute = WordAttributeNames.reg;
    public boolean outputKWIC = false;
    public String outputLeftKWICAttribute = WordAttributeNames.kl;
    public String outputRightKWICAttribute = WordAttributeNames.kr;
    public int outputKWICWidth = 80;
    public boolean outputEOSFlag = true;
    public String outputEOSFlagAttribute = WordAttributeNames.eos;
    public String xmlDoctypeName = "";
    public String xmlDoctypeSystem = "";
    public boolean useXMLHandler = false;
    public boolean ignoreLexiconEntriesForLemmatization = false;
    public boolean tryStandardSpellings = true;
    public boolean useLatinWordList = true;
    public boolean outputWhitespaceElements = true;
    public boolean outputNonredundantAttributesOnly = false;
    public boolean outputNonredundantTokenAttribute = false;
    public boolean outputNonredundantPartAttribute = false;
    public boolean outputNonredundantEosAttribute = false;
    public boolean outputSentenceBoundaryMilestones = false;
    public boolean usePCToMarkEndOfSentence = false;
    public boolean allowLowerCaseProperNouns = false;
    public boolean fixGapTags = true;
    public boolean fixOrigTags = true;
    public boolean fixSplitWords = false;
    public List<PatternReplacer> fixSplitWordsPatternReplacers = null;
    public int pseudoPageSize = 300;
    public boolean outputPseudoPageBoundaryMilestones = false;
    public String pseudoPageContainerDivTypes = "volume chapter sermon";
    public boolean closeSentenceAtEndOfHardTag = false;
    public boolean closeSentenceAtEndOfJumpTag = true;
    public String xmlSchema = "http://ariadne.northwestern.edu/monk/dtds/TEIAnalytics.rng";
    public String disallowWordElementsIn = "figdesc";
    public XMLIDType xmlIDType = XMLIDType.READING_CONTEXT_ORDER;
    public int xmlIDSpacing = 10;
    public boolean xmlTokenLabelEmit = false;
    public String xmlTokenLabelAttribute = "n";
    public int xmlTokenLabelSpacing = 10;
    public boolean xmlTokenLabelPrependWorkName = false;
    public List<String> xmlWordAttributes = ListFactory.createNewList();
    public String abbreviationsURL = "";
    public String abbreviationsMainTextURL = "";
    public String abbreviationsSideTextURL = "";
    public boolean adornExistingXMLFiles = true;
    public boolean tokenizeOnly = false;
    protected static final String STR_ID = "xml.id.attribute";
    protected static final String STR_ID_TYPE = "xml.id.type";
    protected static final String STR_ID_SPACING = "xml.id.spacing";
    protected static final String STR_TOKENLABEL_EMIT = "xml.tokenlabel.emit";
    protected static final String STR_TOKENLABEL_ATTRIBUTE = "xml.tokenlabel.attribute";
    protected static final String STR_TOKENLABEL_SPACING = "xml.tokenlabel.spacing";
    protected static final String STR_TOKENLABEL_PREPENDWORKNAME = "xml.tokenlabel.prependworkname";
    protected static final String STR_LOG = "xml.log";
    protected static final String STR_WORD_PATH = "xml.word_path";
    protected static final String STR_TAGS_PATH = "xml.tags_path";
    protected static final String STR_FIELD_DELIMITERS = "xml.field_delimiters";
    protected static final String STR_WORD_DELIMITERS = "xml.word_delimiters";
    protected static final String STR_SURROUND_MARKER = "xml.surround_marker";
    protected static final String STR_WORD_FIELD = "xml.word_field";
    protected static final String STR_OUTPUT_FILE = "xml.output_file";
    protected static final String STR_ENTITIES_NOT_FILES = "xml.entities_not_files";
    protected static final String STR_ENTITIES_TREAT_ALL = "xml.entities_treat_all";
    protected static final String STR_ENTITIES_MERGE = "xml.entities_merge";
    protected static final String STR_RELATIVE_URI_BASE = "xml.relative_uri_base";
    protected static final String STR_REPEAT_ATTRIBUTES = "xml.repeat_attributes";
    protected static final String STR_JUMP_TAGS = "xml.jump_tags";
    protected static final String STR_SOFT_TAGS = "xml.soft_tags";
    protected static final String STR_PUNC_TAG_NAME = "xml.punc_tag_name";
    protected static final String STR_WORD_TAG_NAME = "xml.word_tag_name";
    protected static final String STR_SPECIAL_SEPARATOR = "xml.special_separator";
    protected static final String STR_IGNORE_TAG_CASE = "xml.ignore_tag_case";
    protected static final String STR_DOCTYPE_NAME = "xml.doctype.name";
    protected static final String STR_DOCTYPE_SYSTEM = "xml.doctype.system";
    protected static final String STR_OUTPUT_WHITESPACE_ELEMENTS = "xml.output_whitespace_elements";
    protected static final String STR_OUTPUT_NONREDUNDANT_ATTRIBUTES_ONLY = "xml.output_nonredundant_attributes_only";
    protected static final String STR_OUTPUT_NONREDUNDANT_TOKEN_ATTRIBUTE = "xml.output_nonredundant_token_attribute";
    protected static final String STR_OUTPUT_NONREDUNDANT_PART_ATTRIBUTE = "xml.output_nonredundant_part_attribute";
    protected static final String STR_OUTPUT_NONREDUNDANT_EOS_ATTRIBUTE = "xml.output_nonredundant_eos_attribute";
    protected static final String STR_OUTPUT_SENTENCE_BOUNDARY_MILESTONES = "xml.output_sentence_boundary_milestones";
    protected static final String STR_USE_PC_TO_MARK_END_OF_SENTENCE = "xml.use_pc_to_mark_end_of_sentence";
    protected static final String STR_FIX_GAP_TAGS = "xml.fix_gap_tags";
    protected static final String STR_FIX_ORIG_TAGS = "xml.fix_orig_tags";
    protected static final String STR_FIX_SPLIT_WORDS = "xml.fix_split_words";
    protected static final String STR_PSEUDO_PAGE_SIZE = "xml.pseudo_page_size";
    protected static final String STR_OUTPUT_PSEUDO_PAGE_BOUNDARY_MILESTONES = "xml.output_pseudo_page_boundary_milestones";
    protected static final String STR_PSEUDO_PAGE_CONTAINER_DIV_TYPES = "xml.pseudo_page_container_div_types";
    protected static final String STR_CLOSE_SENTENCE_AT_END_OF_HARD_TAG = "xml.close_sentence_at_end_of_hard_tag";
    protected static final String STR_CLOSE_SENTENCE_AT_END_OF_JUMP_TAG = "xml.close_sentence_at_end_of_jump_tag";
    protected static final String STR_XMLSCHEMA = "xml.xml_schema";
    protected static final String STR_WORD_LEXICON = "lexicon.word_lexicon";
    protected static final String STR_SUFFIX_LEXICON = "lexicon.suffix_lexicon";
    protected static final String STR_CONTEXT_RULES = "partofspeechtagger.context_rules";
    protected static final String STR_LEXICAL_RULES = "partofspeechtagger.lexical_rules";
    protected static final String STR_STANDARD_SPELLINGS = "spelling.standard_spellings";
    protected static final String STR_SPELLING_PAIRS = "spelling.spelling_pairs";
    protected static final String STR_SPELLING_PAIRS_BY_WORD_CLASS = "spelling.spelling_pairs_by_word_class";
    protected static final String STR_TRANSITION_MATRIX = "partofspeechtagger.transition_matrix";
    protected static final String STR_DISALLOW_WORD_ELEMENTS_IN = "xml.disallow_word_elements_in";
    protected static final String STR_ADORN_EXISTING_XML_FILES = "xml.adorn_existing_xml_files";

    public void initializeSettings(MorphAdornerLogger morphAdornerLogger) {
        this.morphAdornerLogger = morphAdornerLogger;
        this.xgOptions.setLogger(morphAdornerLogger);
        this.xgOptions.setMorphAdornerSettings(this);
        try {
            this.resourceBundle = ResourceBundle.getBundle(resourceName);
        }
        catch (MissingResourceException mre) {
            System.err.println(resourceName + ".properties not found");
            System.exit(0);
        }
        this.programTitle = this.getString("programTitle");
        this.programVersion = this.getString("programVersion");
        this.programBanner = this.getString("programBanner");
    }

    public String getString(String resourceName, String defaultValue) {
        String result;
        try {
            result = this.resourceBundle.getString(resourceName);
        }
        catch (MissingResourceException e) {
            result = defaultValue;
        }
        result = result.replace('_', ' ');
        return result;
    }

    public String getString(String resourceName) {
        String result;
        try {
            result = this.resourceBundle.getString(resourceName);
        }
        catch (MissingResourceException e) {
            result = "";
        }
        result = result.replace('_', ' ');
        return result;
    }

    public String[] getStrings(String resourceName, String[] defaults) {
        String[] result;
        try {
            result = this.splitStrings(this.resourceBundle.getString(resourceName));
        }
        catch (MissingResourceException e) {
            result = defaults;
        }
        return result;
    }

    public String[] splitStrings(String input) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] result = new String[v.size()];
        for (int i = 0; i < result.length; ++i) {
            String s = (String)v.elementAt(i);
            result[i] = s.replace('_', ' ');
        }
        return result;
    }

    protected void getCommandLineParameters(String[] args) {
        if (args.length == 0) {
            MorphAdornerSettings.help();
        }
        try {
            int i;
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option a = parser.addStringOption('a', "alternatespellings");
            CmdLineParser.Option d = parser.addStringOption('d', "defaultproperties");
            CmdLineParser.Option h = parser.addBooleanOption('h', "help");
            CmdLineParser.Option k = parser.addBooleanOption('k', "tokenizeonly");
            CmdLineParser.Option l = parser.addStringOption('l', "lexicon");
            CmdLineParser.Option o = parser.addStringOption('o', "outputdirectory");
            CmdLineParser.Option p = parser.addStringOption('p', "properties");
            CmdLineParser.Option r = parser.addStringOption('r', "contextrules");
            CmdLineParser.Option s = parser.addStringOption('s', "standardspellings");
            CmdLineParser.Option t = parser.addStringOption('t', "transitionmatrix");
            CmdLineParser.Option u = parser.addStringOption('u', "suffixlexicon");
            CmdLineParser.Option w = parser.addStringOption('w', "alternatespellingsbywordclass");
            CmdLineParser.Option x = parser.addStringOption('x', "lexicalrules");
            try {
                parser.parse(args);
            }
            catch (CmdLineParser.OptionException e) {
                System.err.println(e.getMessage());
                MorphAdornerSettings.help();
                System.exit(1);
            }
            if ((Boolean)parser.getOptionValue(h) != null) {
                MorphAdornerSettings.help();
                System.exit(0);
            }
            Vector strings = parser.getOptionValues(a);
            this.alternateSpellingsURLStrings = new String[strings.size()];
            for (i = 0; i < strings.size(); ++i) {
                this.alternateSpellingsURLStrings[i] = (String)strings.get(i);
            }
            strings = parser.getOptionValues(w);
            this.alternateSpellingsByWordClassURLStrings = new String[strings.size()];
            for (i = 0; i < strings.size(); ++i) {
                this.alternateSpellingsByWordClassURLStrings[i] = (String)strings.get(i);
            }
            String defPropURLString = (String)parser.getOptionValue(d);
            if (defPropURLString != null) {
                this.defaultPropertiesURLString = defPropURLString;
            }
            this.tokenizeOnly = (Boolean)parser.getOptionValue(k) != null;
            this.wordLexiconURLString = (String)parser.getOptionValue(l);
            this.outputDirectoryName = (String)parser.getOptionValue(o);
            this.propertiesURLString = (String)parser.getOptionValue(p);
            this.contextRulesURLString = (String)parser.getOptionValue(r);
            this.spellingsURLString = (String)parser.getOptionValue(s);
            this.transitionMatrixURLString = (String)parser.getOptionValue(t);
            this.suffixLexiconURLString = (String)parser.getOptionValue(u);
            this.lexicalRulesURLString = (String)parser.getOptionValue(x);
            this.fileNames = parser.getRemainingArgs();
            this.fileNames = FileNameUtils.expandFileNameWildcards(this.fileNames);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getSettings(String[] args) throws Exception {
        this.getCommandLineParameters(args);
        this.loadProperties();
        this.getOptions();
        this.rectifyOptions();
        this.setXGOptions();
    }

    public void loadProperties() {
        UTF8Properties defaultProperties = null;
        try {
            this.propertiesURL = URLUtils.getURLFromFileNameOrURL(this.defaultPropertiesURLString);
            defaultProperties = UTF8PropertyUtils.loadUTF8Properties(this.propertiesURL);
        }
        catch (Exception e) {
            try {
                this.propertiesURL = URLUtils.getURLFromFileNameOrURL("morphadorner.properties");
                defaultProperties = UTF8PropertyUtils.loadUTF8Properties(this.propertiesURL);
            }
            catch (Exception e2) {
                System.out.println("Unable to load default properties from " + this.defaultPropertiesURLString);
            }
        }
        try {
            this.propertiesURL = URLUtils.getURLFromFileNameOrURL(this.propertiesURLString);
            this.properties = UTF8PropertyUtils.loadUTF8Properties(this.propertiesURL, defaultProperties);
        }
        catch (Exception e) {
            System.out.println("Unable to load configuration properties from " + this.defaultPropertiesURLString);
        }
    }

    protected static void help() {
        System.out.println("java edu.northwestern.at.morphadorner.MorphAdorner [parameters ...] filetotag1 filetotag2 filetotag3 ...");
        System.exit(1);
    }

    public void getOptions() throws Exception {
        this.outputSentenceNumber = this.getBooleanProperty("adorner.output.sentence_number", this.outputSentenceNumber);
        this.outputSentenceNumberAttribute = this.getStringProperty("adorner.output.sentence_number_attribute", this.outputSentenceNumberAttribute);
        this.outputWordOrdinalAttribute = this.getStringProperty("adorner.output.word_ordinal_attribute", this.outputWordOrdinalAttribute);
        this.outputWordOrdinal = this.getBooleanProperty("adorner.output.word_ordinal", this.outputWordOrdinal);
        this.outputWordNumber = this.getBooleanProperty("adorner.output.word_number", this.outputWordNumber);
        this.outputWordNumberAttribute = this.getStringProperty("adorner.output.word_number_attribute", this.outputWordNumberAttribute);
        this.outputRunningWordNumbers = this.getBooleanProperty("adorner.output.running_word_numbers", this.outputRunningWordNumbers);
        this.outputSpelling = this.getBooleanProperty("adorner.output.spelling", this.outputSpelling);
        this.outputSpellingAttribute = this.getStringProperty("adorner.output.spelling_attribute", this.outputSpellingAttribute);
        this.outputOriginalToken = this.getBooleanProperty("adorner.output.original_token", this.outputOriginalToken);
        this.outputOriginalTokenAttribute = this.getStringProperty("adorner.output.original_token_attribute", this.outputOriginalTokenAttribute);
        this.outputPartOfSpeech = this.getBooleanProperty("adorner.output.part_of_speech", this.outputPartOfSpeech);
        this.outputPartOfSpeechAttribute = this.getStringProperty("adorner.output.part_of_speech_attribute", this.outputPartOfSpeechAttribute);
        this.outputLemma = this.getBooleanProperty("adorner.output.lemma", this.outputLemma);
        this.outputLemmaAttribute = this.getStringProperty("adorner.output.lemma_attribute", this.outputLemmaAttribute);
        this.outputStandardSpelling = this.getBooleanProperty("adorner.output.standard_spelling", this.outputStandardSpelling);
        this.outputStandardSpellingAttribute = this.getStringProperty("adorner.output.standard_spelling_attribute", this.outputStandardSpellingAttribute);
        this.outputKWIC = this.getBooleanProperty("adorner.output.kwic", this.outputKWIC);
        this.outputKWIC = this.getBooleanProperty("adorner.output.kwic", this.outputKWIC);
        this.outputLeftKWICAttribute = this.getStringProperty("adorner.output.kwic_left_attribute", this.outputLeftKWICAttribute);
        this.outputRightKWICAttribute = this.getStringProperty("adorner.output.kwic_right_attribute", this.outputRightKWICAttribute);
        this.outputKWICWidth = this.getIntegerProperty("adorner.output.kwic.width", this.outputKWICWidth);
        this.outputEOSFlag = this.getBooleanProperty("adorner.output.end_of_sentence_flag", this.outputEOSFlag);
        this.outputEOSFlagAttribute = this.getStringProperty("adorner.output.end_of_sentence_flag_attribute", this.outputEOSFlagAttribute);
        this.useXMLHandler = this.getBooleanProperty("adorner.handle_xml", this.useXMLHandler);
        this.ignoreLexiconEntriesForLemmatization = this.getBooleanProperty("adorner.lemmatization.ignorelexiconentries", this.ignoreLexiconEntriesForLemmatization);
        this.tryStandardSpellings = this.getBooleanProperty("partofspeechguesser.try_standard_spellings", this.tryStandardSpellings);
        this.useLatinWordList = this.getBooleanProperty("wordlists.use_latin_word_list", this.useLatinWordList);
        this.abbreviationsURL = this.getStringProperty("abbreviations.abbreviations_url", "");
        this.abbreviationsMainTextURL = this.getStringProperty("abbreviations.main.abbreviations_url", "");
        this.abbreviationsSideTextURL = this.getStringProperty("abbreviations.side.abbreviations_url", "");
        this.allowLowerCaseProperNouns = this.getBooleanProperty("adorner.postagger.allow_lower_case_proper_nouns", this.allowLowerCaseProperNouns);
        this.xmlDoctypeName = this.getStringProperty(STR_DOCTYPE_NAME, "");
        this.xmlDoctypeSystem = this.getStringProperty(STR_DOCTYPE_SYSTEM, "");
        this.outputNonredundantAttributesOnly = this.getBooleanProperty(STR_OUTPUT_NONREDUNDANT_ATTRIBUTES_ONLY, this.outputNonredundantAttributesOnly);
        this.outputNonredundantTokenAttribute = this.getBooleanProperty(STR_OUTPUT_NONREDUNDANT_TOKEN_ATTRIBUTE, this.outputNonredundantTokenAttribute);
        this.outputNonredundantPartAttribute = this.getBooleanProperty(STR_OUTPUT_NONREDUNDANT_PART_ATTRIBUTE, this.outputNonredundantPartAttribute);
        this.outputNonredundantEosAttribute = this.getBooleanProperty(STR_OUTPUT_NONREDUNDANT_EOS_ATTRIBUTE, this.outputNonredundantEosAttribute);
        this.outputSentenceBoundaryMilestones = this.getBooleanProperty(STR_OUTPUT_SENTENCE_BOUNDARY_MILESTONES, this.outputSentenceBoundaryMilestones);
        this.usePCToMarkEndOfSentence = this.getBooleanProperty(STR_USE_PC_TO_MARK_END_OF_SENTENCE, this.usePCToMarkEndOfSentence);
        this.adornExistingXMLFiles = this.getBooleanProperty(STR_ADORN_EXISTING_XML_FILES, this.adornExistingXMLFiles);
        this.fixGapTags = this.getBooleanProperty(STR_FIX_GAP_TAGS, this.fixGapTags);
        this.fixOrigTags = this.getBooleanProperty(STR_FIX_ORIG_TAGS, this.fixOrigTags);
        this.fixSplitWords = this.getBooleanProperty(STR_FIX_SPLIT_WORDS, this.fixSplitWords);
        if (this.fixSplitWords) {
            for (int i = 1; i < 500; ++i) {
                String matchString = this.getStringProperty("xml.fix_split_words.match" + i, "");
                String replaceString = this.getStringProperty("xml.fix_split_words.replace" + i, "");
                if (matchString.length() <= 0) continue;
                PatternReplacer patternReplacer = new PatternReplacer(matchString, replaceString);
                if (this.fixSplitWordsPatternReplacers == null) {
                    this.fixSplitWordsPatternReplacers = ListFactory.createNewList();
                }
                this.fixSplitWordsPatternReplacers.add(patternReplacer);
            }
        }
        this.pseudoPageSize = this.getIntegerProperty(STR_PSEUDO_PAGE_SIZE, this.pseudoPageSize);
        this.outputPseudoPageBoundaryMilestones = this.getBooleanProperty(STR_OUTPUT_PSEUDO_PAGE_BOUNDARY_MILESTONES, this.outputPseudoPageBoundaryMilestones);
        this.pseudoPageContainerDivTypes = this.getStringProperty(STR_PSEUDO_PAGE_CONTAINER_DIV_TYPES, this.pseudoPageContainerDivTypes);
        this.closeSentenceAtEndOfHardTag = this.getBooleanProperty(STR_CLOSE_SENTENCE_AT_END_OF_HARD_TAG, this.closeSentenceAtEndOfHardTag);
        this.closeSentenceAtEndOfJumpTag = this.getBooleanProperty(STR_CLOSE_SENTENCE_AT_END_OF_JUMP_TAG, this.closeSentenceAtEndOfJumpTag);
        this.xmlSchema = this.getStringProperty(STR_XMLSCHEMA, this.xmlSchema);
        this.disallowWordElementsIn = this.getStringProperty(STR_DISALLOW_WORD_ELEMENTS_IN, this.disallowWordElementsIn);
        String idType = this.getStringProperty(STR_ID_TYPE, "reading_context_order");
        if (idType.equals("reading_context_order")) {
            this.xmlIDType = XMLIDType.READING_CONTEXT_ORDER;
        } else if (idType.equals("word_within_page_block")) {
            this.xmlIDType = XMLIDType.WORD_WITHIN_PAGE_BLOCK;
        } else if (idType.equals("use_page_block_attributes")) {
            this.xmlIDType = XMLIDType.USE_PAGE_BLOCK_ATTRIBUTES;
        }
        this.xmlIDSpacing = this.getIntegerProperty(STR_ID_SPACING, this.xmlIDSpacing);
        this.xmlIDSpacing = Math.max(1, this.xmlIDSpacing);
        this.xmlTokenLabelEmit = this.getBooleanProperty(STR_TOKENLABEL_EMIT, this.xmlTokenLabelEmit);
        this.xmlTokenLabelAttribute = this.getStringProperty(STR_TOKENLABEL_ATTRIBUTE, this.xmlTokenLabelAttribute);
        this.xmlTokenLabelSpacing = this.getIntegerProperty(STR_TOKENLABEL_SPACING, this.xmlTokenLabelSpacing);
        this.xmlTokenLabelSpacing = Math.max(1, this.xmlTokenLabelSpacing);
        this.xmlTokenLabelPrependWorkName = this.getBooleanProperty(STR_TOKENLABEL_PREPENDWORKNAME, this.xmlTokenLabelPrependWorkName);
        if (this.wordLexiconURLString == null) {
            this.wordLexiconURLString = this.getStringProperty(STR_WORD_LEXICON, "");
        }
        if (this.suffixLexiconURLString == null) {
            this.suffixLexiconURLString = this.getStringProperty(STR_SUFFIX_LEXICON, "");
        }
        if (this.contextRulesURLString == null) {
            this.contextRulesURLString = this.getStringProperty(STR_CONTEXT_RULES, "");
        }
        if (this.lexicalRulesURLString == null) {
            this.lexicalRulesURLString = this.getStringProperty(STR_LEXICAL_RULES, "");
        }
        if (this.spellingsURLString == null) {
            this.spellingsURLString = this.getStringProperty(STR_STANDARD_SPELLINGS, "");
        }
        if (this.alternateSpellingsURLStrings == null || this.alternateSpellingsURLStrings.length == 0) {
            this.alternateSpellingsURLStrings = new String[]{this.getStringProperty(STR_SPELLING_PAIRS, "")};
        }
        if (this.alternateSpellingsByWordClassURLStrings == null || this.alternateSpellingsByWordClassURLStrings.length == 0) {
            this.alternateSpellingsByWordClassURLStrings = new String[]{this.getStringProperty(STR_SPELLING_PAIRS_BY_WORD_CLASS, "")};
        }
        if (this.transitionMatrixURLString == null) {
            this.transitionMatrixURLString = this.getStringProperty(STR_TRANSITION_MATRIX, "");
        }
    }

    public void rectifyOptions() throws Exception {
        int i;
        this.wordLexiconURL = this.wordLexiconURLString == null ? null : new File(this.wordLexiconURLString).toURI().toURL();
        this.suffixLexiconURL = this.suffixLexiconURLString == null ? null : new File(this.suffixLexiconURLString).toURI().toURL();
        this.contextRulesURL = this.contextRulesURLString == null ? null : new File(this.contextRulesURLString).toURI().toURL();
        this.lexicalRulesURL = this.lexicalRulesURLString == null ? null : new File(this.lexicalRulesURLString).toURI().toURL();
        this.spellingsURL = this.spellingsURLString == null ? null : new File(this.spellingsURLString).toURI().toURL();
        this.alternateSpellingsURLs = null;
        if (this.alternateSpellingsURLStrings != null) {
            this.alternateSpellingsURLs = new URL[this.alternateSpellingsURLStrings.length];
            for (i = 0; i < this.alternateSpellingsURLStrings.length; ++i) {
                this.alternateSpellingsURLs[i] = new File(this.alternateSpellingsURLStrings[i]).toURI().toURL();
            }
        }
        this.alternateSpellingsByWordClassURLs = null;
        if (this.alternateSpellingsByWordClassURLStrings != null) {
            this.alternateSpellingsByWordClassURLs = new URL[this.alternateSpellingsByWordClassURLStrings.length];
            for (i = 0; i < this.alternateSpellingsByWordClassURLStrings.length; ++i) {
                this.alternateSpellingsByWordClassURLs[i] = new File(this.alternateSpellingsByWordClassURLStrings[i]).toURI().toURL();
            }
        }
        this.transitionMatrixURL = this.transitionMatrixURLString == null ? null : new File(this.transitionMatrixURLString).toURI().toURL();
    }

    public int setXGOptions() throws IOException {
        int word_field;
        this.xgOptions.setWordTagName(this.getStringProperty(STR_WORD_TAG_NAME, ""));
        if (this.xgOptions.getWordTagName().length() == 0) {
            this.morphAdornerLogger.logError("You must specify a name for tags that will be added with xml.word_tag_name in configuration file.");
            return -1;
        }
        this.xgOptions.setPuncTagName(this.getStringProperty(STR_PUNC_TAG_NAME, ""));
        if (this.xgOptions.getPuncTagName().length() == 0) {
            this.xgOptions.setPuncTagName(this.xgOptions.getWordTagName());
        }
        if ((word_field = this.getIntegerProperty(STR_WORD_FIELD, 1)) <= 0) {
            this.morphAdornerLogger.logError("Please specify a valid (integer) word field with property xml.word_field in the configuration file.");
            return -1;
        }
        this.xgOptions.setWordField(word_field);
        this.xgOptions.repeatAttributes(this.getBooleanProperty(STR_REPEAT_ATTRIBUTES, false));
        String str = this.getStringProperty(STR_RELATIVE_URI_BASE, "");
        if (str.length() != 0) {
            File file = XGMisc.getFile(str);
            if (!file.isDirectory()) {
                this.morphAdornerLogger.logError("Base for relative URIs " + str + " must be an existing directory.");
                return -1;
            }
            this.xgOptions.setRelativeURIBase(file.getPath());
        }
        this.xgOptions.setIgnoreTagCase(this.getBooleanProperty(STR_IGNORE_TAG_CASE, true));
        this.xgOptions.setJumpTags(this.getStringProperty(STR_JUMP_TAGS, ""));
        this.xgOptions.setSoftTags(this.getStringProperty(STR_SOFT_TAGS, ""));
        this.outputWhitespaceElements = this.getBooleanProperty(STR_OUTPUT_WHITESPACE_ELEMENTS, true);
        this.setDelimiters();
        this.setIDs();
        this.setPaths();
        this.setLogFileNames();
        return this.entityReferenceHandling();
    }

    protected int entityReferenceHandling() {
        this.xgOptions.setEntityMerging(this.getBooleanProperty(STR_ENTITIES_MERGE, false));
        this.xgOptions.setEntityTreatAll(this.getBooleanProperty(STR_ENTITIES_TREAT_ALL, false));
        this.xgOptions.setEntityIgnoreFiles(this.getBooleanProperty(STR_ENTITIES_NOT_FILES, false));
        return 0;
    }

    protected int setDelimiters() {
        String s = this.getStringProperty(STR_FIELD_DELIMITERS, "\t");
        if (s.length() > 0) {
            this.xgOptions.setFieldDelimiters(s);
        }
        if ((s = this.getStringProperty(STR_WORD_DELIMITERS, "\r\n")).length() > 0) {
            this.xgOptions.setWordDelimiters(s);
        }
        if ((s = this.getStringProperty(STR_SPECIAL_SEPARATOR, "/sep/")).length() > 0) {
            this.xgOptions.setSpecialSeparator(s);
        }
        if ((s = this.getStringProperty(STR_SURROUND_MARKER, " \ue500 ")).length() > 0) {
            this.xgOptions.setSurroundMarker(s);
        }
        return 0;
    }

    protected int setPaths() throws IOException {
        String strProperty = this.getBooleanStringProperty(STR_WORD_PATH, "false");
        if (!strProperty.equals("false")) {
            this.xgOptions.setWritePath(1);
            if (strProperty.equals("true")) {
                this.xgOptions.setWordPathArgumentName("p");
            } else {
                this.xgOptions.setWordPathArgumentName(strProperty);
            }
        }
        if (!(strProperty = this.getBooleanStringProperty(STR_TAGS_PATH, "false")).equals("false")) {
            this.xgOptions.setWritePath(2);
            if (strProperty.equals("true")) {
                this.xgOptions.setTagsPathArgumentName("p");
            } else {
                this.xgOptions.setTagsPathArgumentName(strProperty);
            }
        }
        return 0;
    }

    protected int setIDs() throws IOException {
        String strProperty = this.getBooleanStringProperty(STR_ID, "false");
        if (strProperty.equals("false")) {
            this.xgOptions.setWriteIds(false);
        } else {
            this.xgOptions.setWriteIds(true);
            if (strProperty.equals("true")) {
                strProperty = "id";
            }
            this.xgOptions.setIdArgumentName(strProperty);
        }
        return 0;
    }

    protected int setLogFileNames() throws IOException {
        String strProperty = this.getBooleanStringProperty(STR_LOG, "");
        if (strProperty.equals("false")) {
            this.xgOptions.setWriteLog(false);
        } else if (strProperty.equals("true")) {
            this.xgOptions.setWriteLog(true);
        }
        return 0;
    }

    public String stripQuotes(String strText) {
        String result = strText;
        if (strText != null && strText.length() > 0 && strText.charAt(0) == '\"' && strText.charAt(strText.length() - 1) == '\"') {
            result = strText.substring(1, strText.length() - 1);
        }
        return result;
    }

    protected boolean getBooleanProperty(String name, boolean defaultValue) {
        boolean result = defaultValue;
        String s = this.stripQuotes(this.properties.getProperty(name));
        if (s != null) {
            result = s.equalsIgnoreCase("1") || s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("y");
        }
        return result;
    }

    protected int getIntegerProperty(String name, int defaultValue) {
        int result = defaultValue;
        String s = this.stripQuotes(this.properties.getProperty(name));
        if (s != null) {
            try {
                result = Integer.parseInt(s);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    protected String getBooleanStringProperty(String name, String defaultValue) {
        String result = defaultValue;
        String s = this.stripQuotes(this.properties.getProperty(name));
        result = s != null ? (s.equalsIgnoreCase("1") || s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("y") ? "true" : (s.length() == 0 || s.equalsIgnoreCase("0") || s.equalsIgnoreCase("false") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("n") ? "false" : s)) : "false";
        return result;
    }

    protected String getStringProperty(String name, String defaultValue) {
        String result = defaultValue;
        String s = this.stripQuotes(this.properties.getProperty(name));
        if (s != null) {
            result = s;
        }
        return result;
    }

    public void setXMLWordAttributes(boolean outputOriginalToken, boolean outputLemma, boolean outputStandardSpelling) {
        this.xmlWordAttributes = ListFactory.createNewList();
        if (this.outputSentenceNumber) {
            this.xmlWordAttributes.add(this.outputSentenceNumberAttribute);
        }
        if (this.outputWordNumber) {
            this.xmlWordAttributes.add(this.outputWordNumberAttribute);
        }
        this.xmlWordAttributes.add(this.outputOriginalTokenAttribute);
        this.xgOptions.setWordField(this.xmlWordAttributes.size());
        if (this.outputSpelling) {
            this.xmlWordAttributes.add(this.outputSpellingAttribute);
        }
        if (this.outputPartOfSpeech) {
            this.xmlWordAttributes.add(this.outputPartOfSpeechAttribute);
        }
        if (outputStandardSpelling) {
            this.xmlWordAttributes.add(this.outputStandardSpellingAttribute);
        }
        if (outputLemma) {
            this.xmlWordAttributes.add(this.outputLemmaAttribute);
        }
        this.xmlWordAttributes.add(this.outputEOSFlagAttribute);
        if (this.outputKWIC) {
            this.xmlWordAttributes.add(this.outputLeftKWICAttribute);
            this.xmlWordAttributes.add(this.outputRightKWICAttribute);
        }
    }

    public String getXMLWordAttribute(int attrIndex) {
        String result = "";
        if (attrIndex >= 0 && attrIndex < this.xmlWordAttributes.size() && (result = this.xmlWordAttributes.get(attrIndex)) == null) {
            result = "";
        }
        return result;
    }

    public List<String> getXMLWordAttributes() {
        return this.xmlWordAttributes;
    }

    public MorphAdornerSettings getSettings() {
        return this;
    }

    public String getMorphAdornerVersion() {
        return this.programVersion;
    }

    public static enum XMLIDType {
        READING_CONTEXT_ORDER,
        WORD_WITHIN_PAGE_BLOCK,
        USE_PAGE_BLOCK_ATTRIBUTES;

    }
}

