/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner;

import edu.northwestern.at.morphadorner.MorphAdornerSettings;
import edu.northwestern.at.utils.logger.BaseLogger;
import edu.northwestern.at.utils.logger.DummyLogger;
import edu.northwestern.at.utils.logger.Logger;
import edu.northwestern.at.utils.logger.StandardOutputLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Formatter;

public class MorphAdornerLogger
implements Serializable {
    protected Logger logger = null;
    protected MorphAdornerSettings morphAdornerSettings = null;

    public MorphAdornerLogger(String configFileName, String logFileDirectory, MorphAdornerSettings morphAdornerSettings) throws FileNotFoundException, IOException {
        this.logger = this.createWrappedLogger(configFileName, logFileDirectory);
        this.morphAdornerSettings = morphAdornerSettings;
    }

    public void terminate() {
        this.logger.terminate();
    }

    public Logger createWrappedLogger(String configFileName, String logFileDirectory) {
        Logger logger = null;
        try {
            logger = logFileDirectory == null || configFileName == null ? new DummyLogger() : new BaseLogger("edu.northwestern.at.morphadorner.MorphAdorner", logFileDirectory, configFileName);
        }
        catch (Exception e) {
            logger = new StandardOutputLogger();
        }
        return logger;
    }

    public void logDebug(String str) {
        this.logger.logDebug(str);
    }

    public void logInfo(String str) {
        this.logger.logInfo(str);
    }

    public void logError(String str) {
        this.logger.logError(str);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void println(String formatString) {
        this.logInfo(this.morphAdornerSettings.getString(formatString));
    }

    public void println(String formatString, String value) {
        StringBuilder sb = new StringBuilder();
        new Formatter(sb).format(this.morphAdornerSettings.getString(formatString), value);
        this.logInfo(sb.toString());
    }

    public void println(String formatString, Object[] objects) {
        StringBuilder sb = new StringBuilder();
        new Formatter(sb).format(this.morphAdornerSettings.getString(formatString), objects);
        this.logInfo(sb.toString());
    }
}

