/*
 * Decompiled with CFR 0.152.
 */
package gate.xml;

import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.corpora.DocumentContentImpl;
import gate.corpora.DocumentImpl;
import gate.event.StatusListener;
import gate.util.GateRuntimeException;
import gate.util.GateSaxException;
import gate.util.InvalidOffsetException;
import gate.util.Out;
import gate.xml.SimpleErrorHandler;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class GateFormatXmlDocumentHandler
extends DefaultHandler {
    private static final boolean DEBUG = false;
    private StringBuffer contentBuffer = new StringBuffer("");
    private boolean readCharacterStatus = false;
    private static final int OLD = 1;
    private static final int NEW = 2;
    private static final int UNDEFINED = 0;
    private int gateXmlFormatType = 0;
    private TreeSet annotationIdSet = new TreeSet();
    private Map classCache = new HashMap();
    static final int ELEMENTS_RATE = 128;
    private SimpleErrorHandler _seh = new SimpleErrorHandler();
    private StringBuffer tmpDocContent = new StringBuffer("");
    private Document doc = null;
    protected List myStatusListeners = new LinkedList();
    private int elements = 0;
    private List colector = null;
    private Map id2Offset = new TreeMap();
    private Stack currentElementStack = new Stack();
    private AnnotationObject currentAnnot = null;
    private FeatureMap currentFeatureMap = null;
    private String currentFeatureName = null;
    private String currentFeatureValue = null;
    private String currentFeatureKeyClassName = null;
    private String currentFeatureKeyItemClassName = null;
    private String currentFeatureValueClassName = null;
    private String currentFeatureValueItemClassName = null;
    private AnnotationSet currentAnnotationSet = null;

    public GateFormatXmlDocumentHandler(Document document) {
        this.tmpDocContent = new StringBuffer(document.getContent().size().intValue());
        this.colector = new LinkedList();
        this.doc = document;
        this.currentAnnotationSet = this.doc.getAnnotations();
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        this.doc.setContent(new DocumentContentImpl(this.tmpDocContent.toString()));
        if (this.gateXmlFormatType == 2 && !this.annotationIdSet.isEmpty()) {
            Integer n = (Integer)this.annotationIdSet.last();
            ((DocumentImpl)this.doc).setNextAnnotationId(n + 1);
            this.annotationIdSet = null;
        }
        this.fireStatusChangedEvent("Total elements: " + this.elements);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.readCharacterStatus) {
            this.readCharacterStatus = false;
            this.charactersAction(new String(this.contentBuffer).toCharArray(), 0, this.contentBuffer.length());
        }
        if (++this.elements % 128 == 0) {
            this.fireStatusChangedEvent("Processed elements : " + this.elements);
        }
        this.currentElementStack.add(string3);
        if ("AnnotationSet".equals(string3)) {
            this.processAnnotationSetElement(attributes);
        }
        if ("Annotation".equals(string3)) {
            this.processAnnotationElement(attributes);
        }
        if ("Feature".equals(string3)) {
            this.processFeatureElement(attributes);
        }
        if ("Name".equals(string3)) {
            this.processNameElement(attributes);
        }
        if ("Value".equals(string3)) {
            this.processValueElement(attributes);
        }
        if ("Node".equals(string3)) {
            this.processNodeElement(attributes);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.readCharacterStatus) {
            this.readCharacterStatus = false;
            this.charactersAction(new String(this.contentBuffer).toCharArray(), 0, this.contentBuffer.length());
        }
        this.currentElementStack.pop();
        if ("Annotation".equals(string3)) {
            if (this.currentFeatureMap == null) {
                this.currentFeatureMap = Factory.newFeatureMap();
            }
            this.currentAnnot.setFM(this.currentFeatureMap);
            this.colector.add(this.currentAnnot);
            this.currentAnnot = null;
            this.currentFeatureMap = null;
            return;
        }
        if ("Value".equals(string3) && "Feature".equals((String)this.currentElementStack.peek()) && this.currentFeatureValue == null) {
            this.currentFeatureValue = "";
        }
        if ("Feature".equals(string3)) {
            if (this.currentFeatureName == null) {
                throw new GateSaxException("A feature name was empty.The annotation that cause it is " + this.currentAnnot + ".Please check the document with a text editor before trying again.");
            }
            if (this.currentFeatureMap == null) {
                throw new GateSaxException("Document not consistent. A start feature element is missing. The annotation that cause it is " + this.currentAnnot + "Please check the document with a text editor before trying again.");
            }
            this.currentFeatureMap.put(this.createFeatKey(), this.createFeatValue());
            this.currentFeatureKeyClassName = null;
            this.currentFeatureKeyItemClassName = null;
            this.currentFeatureName = null;
            this.currentFeatureValueClassName = null;
            this.currentFeatureValueItemClassName = null;
            this.currentFeatureValue = null;
            this.currentFeatureName = null;
            this.currentFeatureValue = null;
            return;
        }
        if ("GateDocumentFeatures".equals(string3)) {
            if (this.currentFeatureMap == null) {
                this.currentFeatureMap = Factory.newFeatureMap();
            }
            this.doc.setFeatures(this.currentFeatureMap);
            this.currentFeatureMap = null;
            return;
        }
        if ("AnnotationSet".equals(string3)) {
            Iterator iterator = this.colector.iterator();
            while (iterator.hasNext()) {
                AnnotationObject annotationObject = (AnnotationObject)iterator.next();
                iterator.remove();
                try {
                    if (annotationObject.getId() == null) {
                        if (this.gateXmlFormatType == 2) {
                            throw new GateSaxException("Found an annotation without ID while previous annotations had one.The NEW GATE XML document format requires all annotations to have an UNIQUE ID. The offending annotation was of [type=" + annotationObject.getElemName() + ", startOffset=" + annotationObject.getStart() + ", endOffset=" + annotationObject.getEnd() + "]");
                        }
                        this.gateXmlFormatType = 1;
                        this.currentAnnotationSet.add(annotationObject.getStart(), annotationObject.getEnd(), annotationObject.getElemName(), annotationObject.getFM());
                        continue;
                    }
                    if (this.gateXmlFormatType == 1) {
                        throw new GateSaxException("Found an annotation with ID while previous annotations didn't have one.The OLD GATE XMLdocument format requires all annotations NOT to have an ID. The offending annotation was of [Id=" + annotationObject.getId() + ", type=" + annotationObject.getElemName() + ", startOffset=" + annotationObject.getStart() + ", endOffset=" + annotationObject.getEnd() + "]");
                    }
                    this.gateXmlFormatType = 2;
                    this.testAnnotationIdUnicity(annotationObject.getId());
                    this.currentAnnotationSet.add(annotationObject.getId(), annotationObject.getStart(), annotationObject.getEnd(), annotationObject.getElemName(), annotationObject.getFM());
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    throw new GateSaxException(invalidOffsetException);
                }
            }
            return;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.readCharacterStatus) {
            this.contentBuffer = new StringBuffer(new String(cArray, n, n2));
        } else {
            this.contentBuffer.append(new String(cArray, n, n2));
        }
        this.readCharacterStatus = true;
    }

    public void charactersAction(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if ("TextWithNodes".equals((String)this.currentElementStack.peek())) {
            this.processTextOfTextWithNodesElement(string);
            return;
        }
        if ("Name".equals((String)this.currentElementStack.peek())) {
            this.processTextOfNameElement(string);
            return;
        }
        if ("Value".equals((String)this.currentElementStack.peek())) {
            this.processTextOfValueElement(string);
            return;
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this._seh.error(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this._seh.fatalError(sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this._seh.warning(sAXParseException);
    }

    private void processAnnotationSetElement(Attributes attributes) {
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string = attributes.getLocalName(i);
                String string2 = attributes.getValue(i);
                if (!"Name".equals(string)) continue;
                this.currentAnnotationSet = this.doc.getAnnotations(string2);
            }
        }
    }

    private void processNameElement(Attributes attributes) {
        if (attributes == null) {
            return;
        }
        this.currentFeatureKeyClassName = attributes.getValue("className");
        this.currentFeatureKeyItemClassName = attributes.getValue("itemClassName");
    }

    private void processValueElement(Attributes attributes) {
        if (attributes == null) {
            return;
        }
        this.currentFeatureValueClassName = attributes.getValue("className");
        this.currentFeatureValueItemClassName = attributes.getValue("itemClassName");
    }

    private void processAnnotationElement(Attributes attributes) {
        if (attributes != null) {
            this.currentAnnot = new AnnotationObject();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string = attributes.getLocalName(i);
                String string2 = attributes.getValue(i);
                if ("Id".equals(string)) {
                    this.currentAnnot.setId(new Integer(string2));
                }
                if ("Type".equals(string)) {
                    this.currentAnnot.setElemName(string2);
                }
                try {
                    Long l;
                    Integer n;
                    if ("StartNode".equals(string)) {
                        n = new Integer(string2);
                        l = (Long)this.id2Offset.get(n);
                        if (l == null) {
                            throw new GateRuntimeException("Couldn't found Node with id = " + n + ".It was specified in annot " + this.currentAnnot + " as a start node!" + "Check the document with a text editor or something" + " before trying again.");
                        }
                        this.currentAnnot.setStart(l);
                    }
                    if (!"EndNode".equals(string)) continue;
                    n = new Integer(string2);
                    l = (Long)this.id2Offset.get(n);
                    if (l == null) {
                        throw new GateRuntimeException("Couldn't found Node with id = " + n + ".It was specified in annot " + this.currentAnnot + " as a end node!" + "Check the document with a text editor or something" + " before trying again.");
                    }
                    this.currentAnnot.setEnd(l);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new GateRuntimeException("Offsets problems.Couldn't create Integers from id[" + string2 + "]) in annot " + this.currentAnnot + "Check the document with a text editor or something," + " before trying again");
                }
            }
        }
    }

    private void processFeatureElement(Attributes attributes) {
        if (this.currentFeatureMap == null) {
            this.currentFeatureMap = Factory.newFeatureMap();
        }
    }

    private void processNodeElement(Attributes attributes) {
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string = attributes.getLocalName(i);
                String string2 = attributes.getValue(i);
                if (!"id".equals(string)) continue;
                try {
                    Integer n = new Integer(string2);
                    this.id2Offset.put(n, new Long(this.tmpDocContent.length()));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new GateRuntimeException("Coudn't create a node from " + string2 + " Expected an integer.");
                }
            }
        }
    }

    private void processTextOfTextWithNodesElement(String string) {
        string = this.recoverNewLineSequence(string);
        this.tmpDocContent.append(string);
    }

    private String recoverNewLineSequence(String string) {
        String string2 = string;
        if (string.indexOf(10) != -1) {
            String string3 = (String)this.doc.getFeatures().get("docNewLineType");
            if ("LF".equalsIgnoreCase(string3)) {
                string3 = null;
            }
            if (string3 == null) {
                return string2;
            }
            String string4 = "\n";
            if ("CRLF".equalsIgnoreCase(string3)) {
                string4 = "\r\n";
            }
            if ("CR".equalsIgnoreCase(string3)) {
                string4 = "\r";
            }
            if ("LFCR".equalsIgnoreCase(string3)) {
                string4 = "\n\r";
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = string.lastIndexOf(10);
            while (n != -1) {
                stringBuffer.replace(n, n + 1, string4);
                n = string.lastIndexOf(10, n - 1);
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private void processTextOfNameElement(String string) throws GateSaxException {
        if (this.currentFeatureMap == null) {
            throw new GateSaxException("GATE xml format processing error: Found a Name element that is not enclosed into a Feature one while analyzing the annotation " + this.currentAnnot + "Please check the document with a text editor or something before" + " trying again.");
        }
        this.currentFeatureName = this.currentFeatureName == null ? string : this.currentFeatureName + string;
    }

    private void processTextOfValueElement(String string) throws GateSaxException {
        if (this.currentFeatureMap == null) {
            throw new GateSaxException("GATE xml format processing error: Found a Value element that is not enclosed into a Feature one while analyzing the annotation " + this.currentAnnot + "Please check the document with a text editor or something before" + " trying again.");
        }
        this.currentFeatureValue = this.currentFeatureValue == null ? string : this.currentFeatureValue + string;
    }

    private Object createFeatKey() {
        return this.createFeatObject(this.currentFeatureKeyClassName, this.currentFeatureKeyItemClassName, this.currentFeatureName);
    }

    private Object createFeatValue() {
        return this.createFeatObject(this.currentFeatureValueClassName, this.currentFeatureValueItemClassName, this.currentFeatureValue);
    }

    private Object createFeatObject(String string, String string2, String string3) {
        if (string3 == null) {
            return null;
        }
        if (string == null) {
            string = "java.lang.String";
        }
        if (string2 == null) {
            string2 = "java.lang.String";
        }
        Class<?> clazz = null;
        clazz = (Class<?>)this.classCache.get(string);
        if (clazz == null) {
            try {
                clazz = Gate.getClassLoader().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return string3;
            }
            this.classCache.put(string, clazz);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Class<Object> clazz2 = null;
            Collection collection = null;
            try {
                collection = (Collection)clazz.newInstance();
                try {
                    clazz2 = Gate.getClassLoader().loadClass(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Out.prln("Warning: Item class " + string2 + " not found." + "Adding items as Strings to the feature called \"" + this.currentFeatureName + "\" in the annotation " + this.currentAnnot);
                    clazz2 = String.class;
                }
                Class[] classArray = new Class[]{String.class};
                Constructor<?> constructor = null;
                boolean bl = false;
                try {
                    constructor = clazz2.getConstructor(classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    bl = true;
                }
                catch (SecurityException securityException) {
                    bl = true;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
                Object[] objectArray = new Object[1];
                Object e = null;
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (bl) {
                        collection.add(string4);
                        continue;
                    }
                    objectArray[0] = string4;
                    try {
                        e = constructor.newInstance(objectArray);
                    }
                    catch (Exception exception) {
                        throw new GateRuntimeException("An item(" + string4 + ")  does not comply with its class" + " definition(" + string2 + ").Happened while tried to" + " add feature: " + string3 + " to the annotation " + this.currentAnnot);
                    }
                    collection.add(e);
                }
            }
            catch (InstantiationException instantiationException) {
                return string3;
            }
            catch (IllegalAccessException illegalAccessException) {
                return string3;
            }
            return collection;
        }
        Class[] classArray = new Class[]{String.class};
        try {
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{string3};
            Object obj = constructor.newInstance(objectArray);
            return obj;
        }
        catch (Exception exception) {
            return string3;
        }
    }

    private void testAnnotationIdUnicity(Integer n) throws GateSaxException {
        if (this.annotationIdSet.contains(n)) {
            throw new GateSaxException("Found two or possibly more annotations with the same ID! The offending ID was " + n);
        }
        this.annotationIdSet.add(n);
    }

    public void comment(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void startParsedEntity(String string) throws SAXException {
    }

    public void endParsedEntity(String string, boolean bl) throws SAXException {
    }

    public void addStatusListener(StatusListener statusListener) {
        this.myStatusListeners.add(statusListener);
    }

    public void removeStatusListener(StatusListener statusListener) {
        this.myStatusListeners.remove(statusListener);
    }

    protected void fireStatusChangedEvent(String string) {
        Iterator iterator = this.myStatusListeners.iterator();
        while (iterator.hasNext()) {
            ((StatusListener)iterator.next()).statusChanged(string);
        }
    }

    class AnnotationObject {
        private String elemName = null;
        private FeatureMap fm = null;
        private Long start = null;
        private Long end = null;
        private Integer id = null;

        public String getElemName() {
            return this.elemName;
        }

        public FeatureMap getFM() {
            return this.fm;
        }

        public Long getStart() {
            return this.start;
        }

        public Long getEnd() {
            return this.end;
        }

        public void setElemName(String string) {
            this.elemName = string;
        }

        public void setFM(FeatureMap featureMap) {
            this.fm = featureMap;
        }

        public void setStart(Long l) {
            this.start = l;
        }

        public void setEnd(Long l) {
            this.end = l;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer n) {
            this.id = n;
        }

        public String toString() {
            return " [id =" + this.id + " type=" + this.elemName + " startNode=" + this.start + " endNode=" + this.end + " features=" + this.fm + "] ";
        }
    }
}

