/*
 * Decompiled with CFR 0.152.
 */
package gate.wordnet;

import gate.wordnet.Word;
import gate.wordnet.WordNetException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.IndexWordSet;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.dictionary.Dictionary;

public class WordImpl
implements Word {
    private String lemma;
    private int senseCount;
    private ArrayList wordSenses;
    private Dictionary wnDictionary;

    public WordImpl(String string, int n, Dictionary dictionary) {
        Assert.assertNotNull((Object)string);
        Assert.assertNotNull((Object)dictionary);
        Assert.assertTrue((n > 0 ? 1 : 0) != 0);
        this.lemma = string;
        this.senseCount = n;
        this.wnDictionary = dictionary;
    }

    public List getWordSenses() throws WordNetException {
        if (null == this.wordSenses) {
            this._loadWordSenses();
        }
        return this.wordSenses;
    }

    private void _loadWordSenses() throws WordNetException {
        try {
            IndexWordSet indexWordSet = this.wnDictionary.lookupAllIndexWords(this.lemma);
            IndexWord[] indexWordArray = indexWordSet.getIndexWordArray();
            for (int i = 0; i < indexWordArray.length; ++i) {
                IndexWord indexWord = indexWordArray[i];
                Synset[] synsetArray = indexWord.getSenses();
                for (int j = 0; j < synsetArray.length; ++j) {
                    Synset synset = synsetArray[j];
                }
            }
        }
        catch (JWNLException jWNLException) {
            throw new WordNetException(jWNLException);
        }
    }

    public String getLemma() {
        return this.lemma;
    }

    public int getSenseCount() {
        return this.senseCount;
    }
}

