/*
 * Decompiled with CFR 0.152.
 */
package gate.wordnet;

import net.didion.jwnl.data.Adjective;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.PointerType;

final class WNHelper {
    private WNHelper() {
    }

    public static POS int2POS(int n) {
        POS pOS = null;
        switch (n) {
            case 1001: {
                pOS = POS.ADJECTIVE;
                break;
            }
            case 1002: {
                pOS = POS.ADVERB;
                break;
            }
            case 1003: {
                pOS = POS.NOUN;
                break;
            }
            case 1004: {
                pOS = POS.VERB;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return pOS;
    }

    public static int POS2int(POS pOS) {
        int n;
        if (pOS.equals(POS.ADJECTIVE)) {
            n = 1001;
        } else if (pOS.equals(POS.ADVERB)) {
            n = 1002;
        } else if (pOS.equals(POS.NOUN)) {
            n = 1003;
        } else if (pOS.equals(POS.VERB)) {
            n = 1004;
        } else {
            throw new IllegalArgumentException();
        }
        return n;
    }

    public static int PointerType2int(PointerType pointerType) {
        if (null == pointerType) {
            throw new IllegalArgumentException();
        }
        if (pointerType.equals(PointerType.ANTONYM)) {
            return 10001;
        }
        if (pointerType.equals(PointerType.ATTRIBUTE)) {
            return 10010;
        }
        if (pointerType.equals(PointerType.CAUSE)) {
            return 10012;
        }
        if (pointerType.equals(PointerType.DERIVED)) {
            return 10018;
        }
        if (pointerType.equals(PointerType.ENTAILMENT)) {
            return 10011;
        }
        if (pointerType.equals(PointerType.HYPERNYM)) {
            return 10002;
        }
        if (pointerType.equals(PointerType.HYPONYM)) {
            return 10003;
        }
        if (pointerType.equals(PointerType.MEMBER_HOLONYM)) {
            return 10004;
        }
        if (pointerType.equals(PointerType.MEMBER_MERONYM)) {
            return 10007;
        }
        if (pointerType.equals(PointerType.PARTICIPLE_OF)) {
            return 10015;
        }
        if (pointerType.equals(PointerType.PART_HOLONYM)) {
            return 10006;
        }
        if (pointerType.equals(PointerType.PART_MERONYM)) {
            return 10009;
        }
        if (pointerType.equals(PointerType.SIMILAR_TO)) {
            return 10016;
        }
        if (pointerType.equals(PointerType.SEE_ALSO)) {
            return 10013;
        }
        if (pointerType.equals(PointerType.SUBSTANCE_MERONYM)) {
            return 10008;
        }
        if (pointerType.equals(PointerType.SUBSTANCE_HOLONYM)) {
            return 10005;
        }
        if (pointerType.equals(PointerType.VERB_GROUP)) {
            return 10014;
        }
        throw new IllegalArgumentException();
    }

    public static PointerType int2PointerType(int n) {
        switch (n) {
            case 10001: {
                return PointerType.ANTONYM;
            }
            case 10010: {
                return PointerType.ATTRIBUTE;
            }
            case 10012: {
                return PointerType.CAUSE;
            }
            case 10018: {
                return PointerType.DERIVED;
            }
            case 10011: {
                return PointerType.ENTAILMENT;
            }
            case 10002: {
                return PointerType.HYPERNYM;
            }
            case 10003: {
                return PointerType.HYPONYM;
            }
            case 10004: {
                return PointerType.MEMBER_HOLONYM;
            }
            case 10007: {
                return PointerType.MEMBER_MERONYM;
            }
            case 10015: {
                return PointerType.PARTICIPLE_OF;
            }
            case 10006: {
                return PointerType.PART_HOLONYM;
            }
            case 10009: {
                return PointerType.PART_MERONYM;
            }
            case 10017: {
                return null;
            }
            case 10013: {
                return PointerType.SEE_ALSO;
            }
            case 10016: {
                return PointerType.SIMILAR_TO;
            }
            case 10005: {
                return PointerType.SUBSTANCE_HOLONYM;
            }
            case 10008: {
                return PointerType.SUBSTANCE_MERONYM;
            }
            case 10014: {
                return PointerType.VERB_GROUP;
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean isValidSemanticPointer(int n) {
        return n == 10010 || n == 10012 || n == 10011 || n == 10002 || n == 10003 || n == 10004 || n == 10007 || n == 10006 || n == 10009 || n == 10016 || n == 10005 || n == 10008 || n == 10013 || n == 10014;
    }

    public static boolean isValidLexicalPointer(int n) {
        return n == 10001 || n == 10017 || n == 10015 || n == 10013 || n == 10018;
    }

    public static int AdjPosition2int(Adjective adjective) {
        int n;
        if (adjective.getAdjectivePosition().equals(Adjective.ATTRIBUTIVE)) {
            n = 10001;
        } else if (adjective.getAdjectivePosition().equals(Adjective.IMMEDIATE_POSTNOMINAL)) {
            n = 10002;
        } else if (adjective.getAdjectivePosition().equals(Adjective.NONE)) {
            n = 10004;
        } else if (adjective.getAdjectivePosition().equals(Adjective.PREDICATIVE)) {
            n = 10003;
        } else {
            throw new IllegalArgumentException();
        }
        return n;
    }
}

