/*
 * Decompiled with CFR 0.152.
 */
package gate.wordnet;

import gate.Gate;
import gate.util.Err;
import gate.wordnet.IndexFileWordNetImpl;
import gate.wordnet.SemanticRelation;
import gate.wordnet.Synset;
import gate.wordnet.WordSense;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestWordNet
extends TestCase {
    private static IndexFileWordNetImpl wnMain = null;

    public TestWordNet(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestWordNet testWordNet = new TestWordNet("");
        try {
            testWordNet.setUp();
            testWordNet.testWN_01();
            testWordNet.testWN_02();
            testWordNet.testWN_03();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void testWN_01() throws Exception {
        String string = (String)Gate.getUserConfig().get("Wordnet_config_file");
        if (string == null) {
            Err.prln("WordNet not present. Test aborted...");
            return;
        }
        List list = wnMain.lookupWord("cup", 1003);
        Assert.assertTrue((list.size() == 8 ? 1 : 0) != 0);
        Iterator iterator = list.iterator();
        block10: for (int i = 0; i < list.size(); ++i) {
            WordSense wordSense = (WordSense)list.get(i);
            Synset synset = wordSense.getSynset();
            Assert.assertNotNull((Object)synset);
            switch (i + 1) {
                case 1: {
                    this.checkSynset(synset, "a small open container usually used for drinking; \"he put the cup back in the saucer\"; \"the handle of the cup was missing\"", 1);
                    continue block10;
                }
                case 2: {
                    this.checkSynset(synset, "the quantity a cup will hold; \"he drank a cup of coffee\"; \"he borrowed a cup of sugar\"", 2);
                    continue block10;
                }
                case 3: {
                    this.checkSynset(synset, "any cup-shaped concavity; \"bees filled the waxen cups with honey\"; \"he wore a jock strap with a metal cup\"; \"the cup of her bra\"", 1);
                    continue block10;
                }
                case 4: {
                    this.checkSynset(synset, "a United States liquid unit equal to 8 fluid ounces", 1);
                    continue block10;
                }
                case 5: {
                    this.checkSynset(synset, "cup-shaped plant organ", 1);
                    continue block10;
                }
                case 6: {
                    this.checkSynset(synset, "punch served in a pitcher instead of a punch bowl", 1);
                    continue block10;
                }
                case 7: {
                    this.checkSynset(synset, "the hole (or metal container in the hole) on a golf green; \"he swore as the ball rimmed the cup and rolled away\"; \"put the flag back in the cup\"", 1);
                    continue block10;
                }
                case 8: {
                    this.checkSynset(synset, "a large metal vessel with two handles that is awarded to the winner of a competition; \"the school kept the cups is a special glass case\"", 2);
                }
            }
        }
    }

    public void testWN_02() throws Exception {
        String string = (String)Gate.getUserConfig().get("Wordnet_config_file");
        if (string == null) {
            Err.prln("WordNet not present. Test aborted...");
            return;
        }
        List list = wnMain.lookupWord("cup", 1003);
        Assert.assertTrue((list.size() == 8 ? 1 : 0) != 0);
        Iterator iterator = list.iterator();
        for (int i = 0; i < list.size(); ++i) {
            WordSense wordSense = (WordSense)list.get(i);
            Synset synset = wordSense.getSynset();
            Assert.assertNotNull((Object)synset);
            if (!synset.getGloss().equals("a small open container usually used for drinking; \"he put the cup back in the saucer\"; \"the handle of the cup was missing\"")) continue;
            List list2 = synset.getSemanticRelations(10002);
            Assert.assertNotNull((Object)list2);
            Assert.assertTrue((2 == list2.size() ? 1 : 0) != 0);
            for (int j = 0; j < list2.size(); ++j) {
                SemanticRelation semanticRelation = (SemanticRelation)list2.get(j);
                Assert.assertTrue((semanticRelation.getType() == 10002 ? 1 : 0) != 0);
                Assert.assertEquals((String)semanticRelation.getSymbol(), (String)"@");
                Assert.assertEquals((Object)semanticRelation.getSource(), (Object)synset);
                Synset synset2 = semanticRelation.getTarget();
                Assert.assertNotNull((Object)synset2);
                Synset synset3 = synset2;
                if (synset2.getGloss().equals("eating and serving dishes collectively")) {
                    synset3 = ((SemanticRelation)synset3.getSemanticRelations(10002).get(0)).getTarget();
                    Assert.assertEquals((String)synset3.getGloss(), (String)"articles for use at the table");
                    synset3 = ((SemanticRelation)synset3.getSemanticRelations(10002).get(0)).getTarget();
                    Assert.assertEquals((String)synset3.getGloss(), (String)"articles of the same kind or material; usually used in combination: silverware; software");
                    synset3 = ((SemanticRelation)synset3.getSemanticRelations(10002).get(0)).getTarget();
                    Assert.assertEquals((String)synset3.getGloss(), (String)"one of a class of artifacts; \"an article of clothing\"");
                    synset3 = ((SemanticRelation)synset3.getSemanticRelations(10002).get(0)).getTarget();
                    Assert.assertEquals((String)synset3.getGloss(), (String)"a man-made object");
                    synset3 = ((SemanticRelation)synset3.getSemanticRelations(10002).get(0)).getTarget();
                    Assert.assertEquals((String)synset3.getGloss(), (String)"a physical (tangible and visible) entity; \"it was full of rackets, balls and other objects\"");
                    synset3 = ((SemanticRelation)synset3.getSemanticRelations(10002).get(0)).getTarget();
                    Assert.assertEquals((String)synset3.getGloss(), (String)"anything having existence (living or nonliving)");
                    continue;
                }
                if (synset2.getGloss().equals("something that holds things, especially for transport or storage")) {
                    synset3 = ((SemanticRelation)synset3.getSemanticRelations(10002).get(0)).getTarget();
                    Assert.assertEquals((String)synset3.getGloss(), (String)"an artifact (or system of artifacts) that is instrumental in accomplishing some end");
                    synset3 = ((SemanticRelation)synset3.getSemanticRelations(10002).get(0)).getTarget();
                    Assert.assertEquals((String)synset3.getGloss(), (String)"a man-made object");
                    synset3 = ((SemanticRelation)synset3.getSemanticRelations(10002).get(0)).getTarget();
                    Assert.assertEquals((String)synset3.getGloss(), (String)"a physical (tangible and visible) entity; \"it was full of rackets, balls and other objects\"");
                    synset3 = ((SemanticRelation)synset3.getSemanticRelations(10002).get(0)).getTarget();
                    Assert.assertEquals((String)synset3.getGloss(), (String)"anything having existence (living or nonliving)");
                    continue;
                }
                Assert.fail();
            }
            break;
        }
    }

    public void testWN_03() throws Exception {
        String string = (String)Gate.getUserConfig().get("Wordnet_config_file");
        if (string == null) {
            Err.prln("WordNet not present. Test aborted...");
            return;
        }
        List list = wnMain.lookupWord("cup", 1003);
        Assert.assertTrue((list.size() == 8 ? 1 : 0) != 0);
        Iterator iterator = list.iterator();
        for (int i = 0; i < list.size(); ++i) {
            WordSense wordSense = (WordSense)list.get(i);
            Synset synset = wordSense.getSynset();
            Assert.assertNotNull((Object)synset);
            if (!synset.getGloss().equals("a small open container usually used for drinking; \"he put the cup back in the saucer\"; \"the handle of the cup was missing\"")) continue;
            List list2 = synset.getSemanticRelations(10003);
            Assert.assertNotNull((Object)list2);
            Assert.assertTrue((9 == list2.size() ? 1 : 0) != 0);
            block12: for (int j = 0; j < list2.size(); ++j) {
                SemanticRelation semanticRelation = (SemanticRelation)list2.get(j);
                Assert.assertTrue((semanticRelation.getType() == 10003 ? 1 : 0) != 0);
                Assert.assertEquals((String)semanticRelation.getSymbol(), (String)"~");
                Assert.assertEquals((Object)semanticRelation.getSource(), (Object)synset);
                Synset synset2 = semanticRelation.getTarget();
                Assert.assertNotNull((Object)synset2);
                switch (j) {
                    case 0: {
                        this.checkSynset(synset2, "usually without a handle", 1);
                        continue block12;
                    }
                    case 1: {
                        this.checkSynset(synset2, "a bowl-shaped drinking vessel; especially the Eucharistic cup", 2);
                        continue block12;
                    }
                    case 2: {
                        this.checkSynset(synset2, "a cup from which coffee is drunk", 1);
                        continue block12;
                    }
                    case 3: {
                        this.checkSynset(synset2, "a paper cup for holding drinks", 3);
                        continue block12;
                    }
                    case 4: {
                        this.checkSynset(synset2, "cup to be passed around for the final toast after a meal", 1);
                        continue block12;
                    }
                    case 5: {
                        this.checkSynset(synset2, "a graduated cup used for measuring ingredients", 1);
                        continue block12;
                    }
                    case 6: {
                        this.checkSynset(synset2, "a drinking cup with a bar inside the rim to keep a man's mustache out of the drink", 2);
                        continue block12;
                    }
                    case 7: {
                        this.checkSynset(synset2, "an ancient Greek drinking cup; two handles and footed base", 1);
                        continue block12;
                    }
                    case 8: {
                        this.checkSynset(synset2, "a cup from which tea is drunk", 1);
                    }
                }
            }
        }
    }

    private void checkSynset(Synset synset, String string, int n) {
        Assert.assertEquals((String)synset.getGloss(), (String)string);
        List list = synset.getWordSenses();
        Assert.assertTrue((list.size() == n ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(TestWordNet.class);
    }

    protected void setUp() throws Exception {
        String string = (String)Gate.getUserConfig().get("Wordnet_config_file");
        if (string == null) {
            return;
        }
        if (null == wnMain) {
            wnMain = new IndexFileWordNetImpl();
            wnMain.setPropertyUrl(new File(string).toURI().toURL());
            wnMain.init();
        }
    }
}

