/*
 * Decompiled with CFR 0.152.
 */
package gate.wordnet;

import gate.util.GateRuntimeException;
import gate.wordnet.AdjectiveImpl;
import gate.wordnet.SemanticRelation;
import gate.wordnet.SemanticRelationImpl;
import gate.wordnet.Synset;
import gate.wordnet.VerbImpl;
import gate.wordnet.WNHelper;
import gate.wordnet.WordImpl;
import gate.wordnet.WordNetException;
import gate.wordnet.WordSense;
import gate.wordnet.WordSenseImpl;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.Adjective;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Pointer;
import net.didion.jwnl.data.PointerTarget;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.Verb;
import net.didion.jwnl.data.Word;
import net.didion.jwnl.dictionary.Dictionary;

public class SynsetImpl
implements Synset {
    private ArrayList wordSenses;
    private ArrayList semRelations;
    private String gloss;
    private int synsetPOS;
    Dictionary wnDictionary;
    private long synsetOffset;

    public SynsetImpl(net.didion.jwnl.data.Synset synset, Dictionary dictionary) throws GateRuntimeException {
        Assert.assertNotNull((Object)synset);
        this.wnDictionary = dictionary;
        this.synsetOffset = synset.getOffset();
        this.synsetPOS = WNHelper.POS2int(synset.getPOS());
        this.gloss = synset.getGloss();
        Word[] wordArray = synset.getWords();
        this.wordSenses = new ArrayList(wordArray.length);
        for (int i = 0; i < wordArray.length; ++i) {
            Adjective adjective;
            Word word = wordArray[i];
            IndexWord indexWord = null;
            try {
                indexWord = this.wnDictionary.lookupIndexWord(word.getPOS(), word.getLemma());
            }
            catch (JWNLException jWNLException) {
                throw new GateRuntimeException(jWNLException.getMessage());
            }
            WordImpl wordImpl = new WordImpl(word.getLemma(), indexWord.getSenseCount(), this.wnDictionary);
            WordSenseImpl wordSenseImpl = null;
            if (this.synsetPOS == 1001) {
                Assert.assertTrue((boolean)(word instanceof Adjective));
                adjective = (Adjective)word;
                wordSenseImpl = new AdjectiveImpl(wordImpl, this, 0, word.getIndex(), false, WNHelper.AdjPosition2int(adjective), this.wnDictionary);
            } else if (this.synsetPOS == 1004) {
                Assert.assertTrue((boolean)(word instanceof Verb));
                adjective = (Verb)word;
                wordSenseImpl = new VerbImpl(wordImpl, this, 0, word.getIndex(), false, (Verb)adjective, this.wnDictionary);
            } else {
                wordSenseImpl = new WordSenseImpl(wordImpl, this, 0, word.getIndex(), false, this.wnDictionary);
            }
            this.wordSenses.add(wordSenseImpl);
        }
    }

    public int getPOS() {
        return this.synsetPOS;
    }

    public boolean isUniqueBeginner() throws WordNetException {
        List list = this.getSemanticRelations(10002);
        return list.isEmpty();
    }

    public String getGloss() {
        return this.gloss;
    }

    public List getWordSenses() {
        return this.wordSenses;
    }

    public WordSense getWordSense(int n) {
        return (WordSense)this.wordSenses.get(n);
    }

    public List getSemanticRelations() throws WordNetException {
        if (null == this.semRelations) {
            this._loadSemanticRelations();
        }
        return this.semRelations;
    }

    public List getSemanticRelations(int n) throws WordNetException {
        ArrayList<SemanticRelation> arrayList = new ArrayList<SemanticRelation>(1);
        if (null == this.semRelations) {
            this._loadSemanticRelations();
        }
        for (SemanticRelation semanticRelation : this.semRelations) {
            Assert.assertNotNull((Object)semanticRelation);
            if (n != semanticRelation.getType()) continue;
            arrayList.add(semanticRelation);
        }
        return arrayList;
    }

    private void _loadSemanticRelations() throws WordNetException {
        POS pOS = null;
        pOS = WNHelper.int2POS(this.synsetPOS);
        try {
            net.didion.jwnl.data.Synset synset = this.wnDictionary.getSynsetAt(pOS, this.synsetOffset);
            Assert.assertNotNull((Object)synset);
            Pointer[] pointerArray = synset.getPointers();
            this.semRelations = new ArrayList(pointerArray.length);
            for (int i = 0; i < pointerArray.length; ++i) {
                Pointer pointer = pointerArray[i];
                if (pointer.isLexical()) continue;
                PointerType pointerType = pointer.getType();
                PointerTarget pointerTarget = pointer.getTarget();
                Assert.assertTrue((boolean)(pointerTarget instanceof net.didion.jwnl.data.Synset));
                net.didion.jwnl.data.Synset synset2 = (net.didion.jwnl.data.Synset)pointerTarget;
                SynsetImpl synsetImpl = new SynsetImpl(synset2, this.wnDictionary);
                SemanticRelationImpl semanticRelationImpl = new SemanticRelationImpl(WNHelper.PointerType2int(pointerType), this, synsetImpl);
                this.semRelations.add(semanticRelationImpl);
            }
        }
        catch (JWNLException jWNLException) {
            throw new WordNetException(jWNLException);
        }
    }

    public long getOffset() {
        return this.synsetOffset;
    }
}

