/*
 * Decompiled with CFR 0.152.
 */
package gate.wordnet;

import gate.wordnet.Relation;
import gate.wordnet.WNHelper;

class RelationImpl
implements Relation {
    private int type;

    protected RelationImpl(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public String getSymbol() {
        return WNHelper.int2PointerType(this.type).getKey();
    }

    public String getLabel() {
        return WNHelper.int2PointerType(this.type).getLabel();
    }

    public int getInverseType() {
        switch (this.type) {
            case 10001: {
                return 10001;
            }
            case 10003: {
                return 10002;
            }
            case 10002: {
                return 10003;
            }
            case 10004: {
                return 10007;
            }
            case 10007: {
                return 10004;
            }
            case 10016: {
                return 10016;
            }
            case 10010: {
                return 10010;
            }
            case 10014: {
                return 10014;
            }
        }
        return -1;
    }

    public boolean isApplicableTo(int n) {
        return WNHelper.int2PointerType(this.type).appliesTo(WNHelper.int2POS(n));
    }
}

