/*
 * Decompiled with CFR 0.152.
 */
package gate.util.web;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.ProcessingResource;
import gate.Resource;
import gate.annotation.AnnotationSetImpl;
import gate.corpora.RepositioningInfo;
import gate.creole.SerialAnalyserController;
import gate.util.GateException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Vector;
import javax.servlet.ServletContext;

public class WebCrimeReportAnalyser {
    public static final String SOCIS_CONTROLLER_KEY = "socis.controller";
    public static final String GATE_INIT_KEY = "gate.init";
    public String filePath = "";
    private SerialAnalyserController controller;

    public void initCrimeReportAnalyser() throws GateException {
        Serializable serializable;
        Serializable serializable2;
        this.controller = (SerialAnalyserController)Factory.createResource("gate.creole.SerialAnalyserController", Factory.newFeatureMap(), Factory.newFeatureMap(), "Crime Report Analyser");
        ProcessingResource processingResource = (ProcessingResource)Factory.createResource("gate.creole.tokeniser.DefaultTokeniser", Factory.newFeatureMap());
        this.controller.add(processingResource);
        ProcessingResource processingResource2 = (ProcessingResource)Factory.createResource("gate.creole.splitter.SentenceSplitter", Factory.newFeatureMap());
        this.controller.add(processingResource2);
        ProcessingResource processingResource3 = (ProcessingResource)Factory.createResource("gate.creole.POSTagger", Factory.newFeatureMap());
        this.controller.add(processingResource3);
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("encoding", "ISO-8859-1");
        try {
            serializable2 = new URL("jar:file:" + this.filePath + "files.jar!/resources/gazetters/general/lists.def");
            featureMap.put("listsURL", serializable2);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        serializable2 = (ProcessingResource)Factory.createResource("gate.creole.gazetteer.DefaultGazetteer", featureMap);
        this.controller.add((ProcessingResource)serializable2);
        FeatureMap featureMap2 = Factory.newFeatureMap();
        try {
            serializable = new URL("jar:file:" + this.filePath + "files.jar!/resources/grammars/NamedEntities/socismain.jape");
            featureMap2.put("grammarURL", serializable);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        serializable = (ProcessingResource)Factory.createResource("gate.creole.ANNIETransducer", featureMap2);
        this.controller.add((ProcessingResource)serializable);
    }

    public String process(ServletContext servletContext, String string, String[] stringArray) throws GateException, IOException {
        Serializable serializable;
        if (servletContext.getAttribute(GATE_INIT_KEY) == null) {
            Gate.setLocalWebServer(false);
            Gate.setNetConnected(false);
            System.setProperty("java.protocol.handler.pkgs", "gate.util.protocols");
            Gate.init();
            servletContext.setAttribute(GATE_INIT_KEY, (Object)"true");
        }
        if (servletContext.getAttribute(SOCIS_CONTROLLER_KEY) == null) {
            serializable = Gate.getCreoleRegister();
            this.filePath = servletContext.getInitParameter("files.path");
            this.initCrimeReportAnalyser();
            servletContext.setAttribute(SOCIS_CONTROLLER_KEY, (Object)this.controller);
        } else {
            this.controller = (SerialAnalyserController)servletContext.getAttribute(SOCIS_CONTROLLER_KEY);
        }
        serializable = (Corpus)Factory.createResource("gate.corpora.CorpusImpl");
        URL uRL = new URL(string);
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("sourceUrl", uRL);
        featureMap.put("preserveOriginalContent", new Boolean(true));
        featureMap.put("collectRepositioningInfo", new Boolean(true));
        Document document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        serializable.add(document);
        this.controller.setCorpus((Corpus)serializable);
        this.controller.execute();
        AnnotationSet annotationSet = document.getAnnotations();
        AnnotationSet annotationSet2 = document.getAnnotations("ChunkAnnotations");
        HashSet<String> hashSet = new HashSet<String>();
        HashSet hashSet2 = new HashSet();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        AnnotationSet annotationSet3 = annotationSet.get(hashSet);
        FeatureMap featureMap2 = document.getFeatures();
        String string2 = (String)featureMap2.get("Original_document_content_on_load");
        RepositioningInfo repositioningInfo = (RepositioningInfo)featureMap2.get("Document_repositioning_info");
        SortedAnnotationList sortedAnnotationList = new SortedAnnotationList();
        if (annotationSet3 != null) {
            for (Annotation annotation : annotationSet3) {
                sortedAnnotationList.addSortedExclusive(annotation);
            }
        }
        AnnotationSetImpl annotationSetImpl = new AnnotationSetImpl(document);
        annotationSetImpl.addAll(sortedAnnotationList);
        SortedAnnotationList sortedAnnotationList2 = new SortedAnnotationList();
        String string3 = document.toXml(annotationSetImpl, true);
        Factory.deleteResource(document);
        Factory.deleteResource((Resource)serializable);
        return string3;
    }

    public static class SortedAnnotationList
    extends Vector {
        public boolean addSortedExclusive(Annotation annotation) {
            int n;
            Annotation annotation2 = null;
            for (int i = 0; i < this.size(); ++i) {
                annotation2 = (Annotation)this.get(i);
                if (!annotation.overlaps(annotation2)) continue;
                return false;
            }
            long l = annotation.getStartNode().getOffset();
            for (n = 0; n < this.size(); ++n) {
                annotation2 = (Annotation)this.get(n);
                long l2 = annotation2.getStartNode().getOffset();
                if (l >= l2) continue;
                this.insertElementAt(annotation, n);
                return true;
            }
            n = this.size();
            this.insertElementAt(annotation, n);
            return true;
        }
    }
}

