/*
 * Decompiled with CFR 0.152.
 */
package gate.util.spring;

import gate.Factory;
import gate.FeatureMap;
import gate.util.GateException;
import gate.util.persistence.PersistenceManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.springframework.core.io.Resource;

public class SpringFactory {
    public static FeatureMap createFeatureMap(Map map) throws IOException {
        FeatureMap featureMap = Factory.newFeatureMap();
        for (Map.Entry entry : map.entrySet()) {
            Object k = entry.getKey();
            Object object = entry.getValue();
            if (object instanceof Resource) {
                object = ((Resource)object).getURL();
            }
            featureMap.put(k, object);
        }
        return featureMap;
    }

    public static Object loadObjectFromResource(Resource resource) throws GateException, IOException {
        File file = null;
        try {
            file = resource.getFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (file != null) {
            return PersistenceManager.loadObjectFromFile(file);
        }
        URL uRL = resource.getURL();
        return PersistenceManager.loadObjectFromUrl(uRL);
    }
}

