/*
 * Decompiled with CFR 0.152.
 */
package gate.util.spring;

import gate.Gate;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.springframework.core.io.Resource;

public class Init {
    private List plugins;

    public void setGateHome(Resource resource) throws IOException {
        Gate.setGateHome(resource.getFile());
    }

    public void setPluginsHome(Resource resource) throws IOException {
        Gate.setPluginsHome(resource.getFile());
    }

    public void setSiteConfigFile(Resource resource) throws IOException {
        Gate.setSiteConfigFile(resource.getFile());
    }

    public void setUserConfigFile(Resource resource) throws IOException {
        Gate.setUserConfigFile(resource.getFile());
    }

    public void setBuiltinCreoleDir(Resource resource) throws IOException {
        Gate.setBuiltinCreoleDir(resource.getURL());
    }

    public void setPreloadPlugins(List list) {
        this.plugins = list;
    }

    public void init() throws Exception {
        Gate.init();
        if (this.plugins != null && !this.plugins.isEmpty()) {
            for (Object e : this.plugins) {
                URL uRL;
                if (e instanceof URL) {
                    uRL = (URL)e;
                } else if (e instanceof Resource) {
                    uRL = ((Resource)e).getURL();
                } else if (e instanceof String) {
                    uRL = new URL((String)e);
                } else if (e instanceof File) {
                    uRL = ((File)e).toURI().toURL();
                } else {
                    throw new IllegalArgumentException("Found a " + e.getClass().getName() + " in preloadPlugins, " + "but it must contain only " + "URL, org.springframework.core.io.Resource, File or String");
                }
                Gate.getCreoleRegister().registerDirectories(uRL);
            }
        }
    }
}

