/*
 * Decompiled with CFR 0.152.
 */
package gate.util.profile;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class Profiler {
    private PrintStream m_out;
    private boolean m_enabled = true;
    private boolean m_garbageCollection = true;
    private boolean m_doPrintToStdOut = true;
    private Hashtable m_categorySums;
    private Hashtable m_categoryLasts;
    private Runtime m_rt = Runtime.getRuntime();
    private long m_startTime;
    private long m_lastCheckTime;
    private long m_profilerTime;
    private long m_lastDuration;
    private long m_maxMemory;
    private long m_currMemory;
    private long m_diffMemory;

    public Profiler() {
        this.m_out = System.out;
    }

    public void enable(boolean bl) {
        this.m_enabled = bl;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void enableGCCalling(boolean bl) {
        this.m_garbageCollection = bl;
    }

    public boolean isGCCallingEnabled() {
        return this.m_garbageCollection;
    }

    public long getProfilerTime() {
        return this.m_profilerTime;
    }

    public long getNetRunTime() {
        return this.m_lastCheckTime - this.m_profilerTime;
    }

    public long getRunDuration() {
        return this.m_lastCheckTime;
    }

    public String initRun(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-----------------------------------------------\n");
        stringBuffer.append("New profiler run: " + string);
        stringBuffer.append("\n-----------------------------------------------\n");
        this.m_maxMemory = 0L;
        this.m_currMemory = 0L;
        this.m_diffMemory = 0L;
        this.m_profilerTime = 0L;
        this.m_startTime = System.currentTimeMillis();
        this.m_lastCheckTime = 0L;
        this.m_lastDuration = 0L;
        this.m_categorySums = new Hashtable();
        this.m_categoryLasts = new Hashtable();
        if (this.m_doPrintToStdOut) {
            this.m_out.print(stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public String checkPoint(String string) {
        return this.checkPoint(string, new String[0], true, true, true);
    }

    public String checkPoint(String string, String[] stringArray, boolean bl, boolean bl2, boolean bl3) {
        if (!this.m_enabled) {
            return "";
        }
        long l = System.currentTimeMillis() - this.m_startTime;
        this.m_lastDuration = l - this.m_lastCheckTime;
        if (bl3) {
            long l2 = this.m_currMemory;
            if (this.m_garbageCollection) {
                do {
                    this.m_currMemory = this.m_rt.totalMemory() - this.m_rt.freeMemory();
                    this.m_rt.gc();
                    try {
                        this.wait(300L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.m_rt.gc();
                } while (this.m_currMemory > this.m_rt.totalMemory() - this.m_rt.freeMemory());
            } else {
                this.m_currMemory = this.m_rt.totalMemory() - this.m_rt.freeMemory();
            }
            this.m_currMemory /= 1000L;
            this.m_maxMemory = Math.max(this.m_maxMemory, this.m_currMemory);
            this.m_diffMemory = this.m_currMemory - l2;
        }
        this.m_lastCheckTime = System.currentTimeMillis() - this.m_startTime;
        this.m_profilerTime += this.m_lastCheckTime - l;
        this.checkCategories(stringArray);
        return this.showResults(string, bl, bl2);
    }

    private void checkCategories(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i].toUpperCase();
            Long l = (Long)this.m_categorySums.get(string);
            long l2 = l == null ? 0L : l;
            this.m_categorySums.put(string, new Long(l2 += this.m_lastDuration));
            this.m_categoryLasts.put(string, new Long(this.m_lastDuration));
        }
    }

    private String showResults(String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(500);
        if (bl) {
            stringBuffer.append("---------LOG: ");
            stringBuffer.append(string);
            stringBuffer.append("---------");
        }
        if (bl2) {
            stringBuffer.append("\nMemory: ");
            stringBuffer.append(this.m_currMemory);
            stringBuffer.append("k; change: ");
            stringBuffer.append(this.m_diffMemory);
            stringBuffer.append("k; max: ");
            stringBuffer.append(this.m_maxMemory);
            stringBuffer.append("k; Net time:   ");
            stringBuffer.append(this.printTime(this.getNetRunTime()));
            stringBuffer.append("; since prev.: ");
            stringBuffer.append(this.printTime(this.m_lastDuration));
        }
        if (stringBuffer.length() > 0 && this.m_doPrintToStdOut) {
            this.m_out.println(stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public long getCategoryTimeSum(String string) {
        Long l = (Long)this.m_categorySums.get(string.toUpperCase());
        return l == null ? 0L : l;
    }

    public long getCategoryTimeLast(String string) {
        Long l = (Long)this.m_categoryLasts.get(string.toUpperCase());
        return l == null ? 0L : l;
    }

    public void showCategoryTimes() {
        this.m_out.println("Time spent by categories:");
        Enumeration enumeration = this.m_categorySums.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.showCategoryTime(string);
        }
    }

    public void showCategoryTime(String string) {
        this.m_out.println(string + ", sum=" + this.printTime(this.getCategoryTimeSum(string)) + ", last=" + this.printTime(this.getCategoryTimeLast(string)));
    }

    public String printTime(long l) {
        long l2 = l / 1000L;
        long l3 = l % 1000L / 10L;
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(l2);
        stringBuffer.append(".");
        stringBuffer.append(l3);
        stringBuffer.append("s");
        return stringBuffer.toString();
    }

    public String printSpeed(long l, double d, String string) {
        double d2 = d / (double)l;
        long l2 = (long)(d2 * 1000.0);
        long l3 = (long)(d2 * 100000.0 - (double)(100L * l2));
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(l2);
        stringBuffer.append(".");
        stringBuffer.append(l3);
        stringBuffer.append(string);
        stringBuffer.append("/s");
        return stringBuffer.toString();
    }

    public void printCategAvg(String string, long l, double d, String string2) {
        long l2 = this.getCategoryTimeSum(string);
        if (l2 == 0L) {
            this.m_out.println("Category \"" + string + "\" not found");
        }
        this.m_out.println("Category \"" + string + "\",  Time= " + this.printTime(l2) + "; avg. time= " + this.printTime(l2 / l) + "; speed= " + this.printSpeed(l2, d, string2));
    }

    public void printToSystemOut(boolean bl) {
        this.m_doPrintToStdOut = bl;
    }
}

