/*
 * Decompiled with CFR 0.152.
 */
package gate.util.persistence;

import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.creole.Parameter;
import gate.creole.ParameterList;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.persist.PersistenceException;
import gate.util.NameBearer;
import gate.util.persistence.Persistence;
import gate.util.persistence.PersistenceManager;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class ResourcePersistence
implements Persistence {
    protected String resourceType;
    protected String resourceName;
    protected Object initParams;
    protected Object features;
    static final long serialVersionUID = -3196664486112887875L;

    ResourcePersistence() {
    }

    public void extractDataFromSource(Object object) throws PersistenceException {
        ResourceData resourceData;
        if (!(object instanceof Resource)) {
            throw new UnsupportedOperationException(this.getClass().getName() + " can only be used for " + Resource.class.getName() + " objects!\n" + object.getClass().getName() + " is not a " + Resource.class.getName());
        }
        Resource resource = (Resource)object;
        this.resourceType = resource.getClass().getName();
        if (resource instanceof NameBearer) {
            this.resourceName = resource.getName();
        }
        if ((resourceData = (ResourceData)Gate.getCreoleRegister().get(this.resourceType)) == null) {
            throw new PersistenceException("Could not find CREOLE data for " + this.resourceType);
        }
        ParameterList parameterList = resourceData.getParameterList();
        try {
            this.initParams = Factory.newFeatureMap();
            Iterator<List<Parameter>> iterator = parameterList.getInitimeParameters().iterator();
            while (iterator.hasNext()) {
                for (Parameter parameter : iterator.next()) {
                    String string = parameter.getName();
                    Object object2 = resource.getParameterValue(string);
                    ((Map)this.initParams).put(string, object2);
                }
            }
            this.initParams = PersistenceManager.getPersistentRepresentation(this.initParams);
            if (resource.getFeatures() != null) {
                this.features = Factory.newFeatureMap();
                ((Map)this.features).putAll(resource.getFeatures());
                this.features = PersistenceManager.getPersistentRepresentation(this.features);
            }
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw new PersistenceException(resourceInstantiationException);
        }
    }

    public Object createObject() throws PersistenceException, ResourceInstantiationException {
        if (this.initParams != null) {
            this.initParams = PersistenceManager.getTransientRepresentation(this.initParams);
        }
        if (this.features != null) {
            this.features = PersistenceManager.getTransientRepresentation(this.features);
        }
        Resource resource = Factory.createResource(this.resourceType, (FeatureMap)this.initParams, (FeatureMap)this.features, this.resourceName);
        return resource;
    }
}

