/*
 * Decompiled with CFR 0.152.
 */
package gate.util.persistence;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.thoughtworks.xstream.io.xml.StaxReader;
import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import gate.Controller;
import gate.Corpus;
import gate.DataStore;
import gate.Gate;
import gate.LanguageAnalyser;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.VisualResource;
import gate.creole.AnalyserRunningStrategy;
import gate.creole.ConditionalController;
import gate.creole.ResourceInstantiationException;
import gate.creole.SerialAnalyserController;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.gui.MainFrame;
import gate.persist.JDBCDataStore;
import gate.persist.PersistenceException;
import gate.util.Err;
import gate.util.Files;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.NameBearer;
import gate.util.persistence.AnalyserRunningStrategyPersistence;
import gate.util.persistence.CollectionPersistence;
import gate.util.persistence.ConditionalControllerPersistence;
import gate.util.persistence.ControllerPersistence;
import gate.util.persistence.CorpusPersistence;
import gate.util.persistence.DSPersistence;
import gate.util.persistence.GateApplication;
import gate.util.persistence.JDBCDSPersistence;
import gate.util.persistence.LRPersistence;
import gate.util.persistence.LanguageAnalyserPersistence;
import gate.util.persistence.MapPersistence;
import gate.util.persistence.PRPersistence;
import gate.util.persistence.Persistence;
import gate.util.persistence.SerialAnalyserControllerPersistence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class PersistenceManager {
    private static final boolean DEBUG = false;
    private static final String[] STARTOFXMLAPPLICATIONFILES = new String[]{"<gate.util.persistence.GateApplication>", "<?xml", "<!DOCTYPE"};
    private static Map persistentReplacementTypes;
    private static Map existingPersitentReplacements;
    private static Map existingTransientValues;
    private static ClassComparator classComparator;
    static boolean exceptionOccured;
    static File persistenceFile;
    static URL persistenceURL;

    static Serializable getPersistentRepresentation(Object object) throws PersistenceException {
        StatusListener statusListener;
        if (object == null) {
            return null;
        }
        Persistence persistence = (Persistence)existingPersitentReplacements.get(new ObjectHolder(object));
        if (persistence != null) {
            return persistence;
        }
        Class<?> clazz = object.getClass();
        Class clazz2 = PersistenceManager.getMostSpecificPersistentType(clazz);
        if (clazz2 == null) {
            if (object instanceof Serializable) {
                return (Serializable)object;
            }
            throw new PersistenceException("Could not find a serialisable replacement for " + clazz);
        }
        try {
            persistence = (Persistence)clazz2.newInstance();
        }
        catch (Exception exception) {
            throw new PersistenceException(exception);
        }
        if (object instanceof NameBearer && (statusListener = (StatusListener)MainFrame.getListeners().get("gate.event.StatusListener")) != null) {
            statusListener.statusChanged("Storing " + ((NameBearer)object).getName());
        }
        persistence.extractDataFromSource(object);
        existingPersitentReplacements.put(new ObjectHolder(object), persistence);
        return persistence;
    }

    static Object getTransientRepresentation(Object object) throws PersistenceException, ResourceInstantiationException {
        if (object == null || object instanceof SlashDevSlashNull) {
            return null;
        }
        if (object instanceof Persistence) {
            ObjectHolder objectHolder = new ObjectHolder(object);
            Object object2 = existingTransientValues.get(objectHolder);
            if (object2 != null) {
                return object2;
            }
            object2 = ((Persistence)object).createObject();
            existingTransientValues.put(objectHolder, object2);
            return object2;
        }
        return object;
    }

    protected static Class getMostSpecificPersistentType(Class clazz) {
        ArrayList<Class<Object>> arrayList = new ArrayList<Class<Object>>();
        arrayList.add(clazz);
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        while (!arrayList.isEmpty()) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Class clazz2 = (Class)persistentReplacementTypes.get(iterator.next());
                if (clazz2 == null) continue;
                return clazz2;
            }
            if (clazz != null) {
                clazz = clazz.getSuperclass();
            }
            arrayList2.clear();
            arrayList3.clear();
            arrayList4.clear();
            for (Class clazz3 : arrayList) {
                Class<?>[] classArray = clazz3.getInterfaces();
                for (int i = 0; i < classArray.length; ++i) {
                    Class<?> clazz4 = classArray[i];
                    String string = clazz4.getName();
                    if (string.startsWith("java")) {
                        arrayList4.add(clazz4);
                        continue;
                    }
                    if (string.startsWith("gate")) {
                        arrayList3.add(clazz4);
                        continue;
                    }
                    arrayList2.add(clazz4);
                }
            }
            arrayList.clear();
            if (clazz != null) {
                arrayList.add(clazz);
            }
            arrayList.addAll(arrayList2);
            arrayList.addAll(arrayList3);
            arrayList.addAll(arrayList4);
        }
        return null;
    }

    public static String getRelativePath(URL uRL, URL uRL2) {
        if (uRL.getProtocol().equals("file") && uRL2.getProtocol().equals("file")) {
            int n;
            File file;
            File file2 = Files.fileFromURL(uRL);
            File file3 = Files.fileFromURL(uRL2);
            ArrayList<File> arrayList = new ArrayList<File>();
            for (file = file3.getParentFile(); file != null; file = file.getParentFile()) {
                arrayList.add(0, file);
            }
            ArrayList<File> arrayList2 = new ArrayList<File>();
            for (file = file2.getParentFile(); file != null; file = file.getParentFile()) {
                arrayList2.add(0, file);
            }
            for (int i = 0; i < arrayList.size() && i < arrayList2.size() && arrayList.get(i).equals(arrayList2.get(i)); ++i) {
            }
            String string = "";
            for (n = i; n < arrayList2.size(); ++n) {
                string = string.length() == 0 ? string + ".." : string + "/..";
            }
            for (n = i; n < arrayList.size(); ++n) {
                String string2 = ((File)arrayList.get(n)).getName();
                if (string2.length() == 0 && (string2 = ((File)arrayList.get(n)).getAbsolutePath()).endsWith(File.separator)) {
                    string2 = string2.substring(0, string2.length() - File.separator.length());
                }
                string = string.length() == 0 ? string + string2 : string + "/" + string2;
            }
            string = string.length() == 0 ? string + file3.getName() : string + "/" + file3.getName();
            try {
                URI uRI = new URI(null, null, string, null, null);
                return uRI.getRawPath();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new GateRuntimeException("Failed to generate relative path between context: " + uRL + " and target: " + uRL2, uRISyntaxException);
            }
        }
        throw new GateRuntimeException("Both the target and the context URLs need to be \"file:\" URLs!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveObjectToFile(Object object, File file) throws PersistenceException, IOException {
        PrettyPrintWriter prettyPrintWriter;
        long l;
        StatusListener statusListener;
        ProgressListener progressListener;
        block14: {
            progressListener = (ProgressListener)MainFrame.getListeners().get("gate.event.ProgressListener");
            statusListener = (StatusListener)MainFrame.getListeners().get("gate.event.StatusListener");
            l = System.currentTimeMillis();
            if (progressListener != null) {
                progressListener.progressChanged(0);
            }
            ObjectOutputStream objectOutputStream = null;
            XStream xStream = null;
            prettyPrintWriter = null;
            persistenceFile = file;
            try {
                Object object2;
                existingPersitentReplacements.clear();
                existingPersitentReplacements.clear();
                if (Gate.getUseXMLSerialization()) {
                    xStream = new XStream();
                    object2 = new FileWriter(file);
                    prettyPrintWriter = new PrettyPrintWriter((Writer)object2, new XmlFriendlyReplacer("-", "_"));
                } else {
                    objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                }
                object2 = new ArrayList(Gate.getCreoleRegister().getDirectories());
                Serializable serializable = PersistenceManager.getPersistentRepresentation(object2);
                Serializable serializable2 = PersistenceManager.getPersistentRepresentation(object);
                if (Gate.getUseXMLSerialization()) {
                    GateApplication gateApplication = new GateApplication();
                    gateApplication.urlList = serializable;
                    gateApplication.application = serializable2;
                    xStream.marshal((Object)gateApplication, (HierarchicalStreamWriter)prettyPrintWriter);
                } else {
                    objectOutputStream.writeObject(serializable);
                    objectOutputStream.writeObject(serializable2);
                }
                Object var14_12 = null;
                persistenceFile = null;
                if (objectOutputStream == null) break block14;
            }
            catch (Throwable throwable) {
                Object var14_13 = null;
                persistenceFile = null;
                if (objectOutputStream != null) {
                    objectOutputStream.flush();
                    objectOutputStream.close();
                }
                if (prettyPrintWriter != null) {
                    prettyPrintWriter.flush();
                    prettyPrintWriter.close();
                }
                long l2 = System.currentTimeMillis();
                if (statusListener != null) {
                    statusListener.statusChanged("Storing completed in " + NumberFormat.getInstance().format((double)(l2 - l) / 1000.0) + " seconds");
                }
                if (progressListener != null) {
                    progressListener.processFinished();
                }
                throw throwable;
            }
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        if (prettyPrintWriter != null) {
            prettyPrintWriter.flush();
            prettyPrintWriter.close();
        }
        long l3 = System.currentTimeMillis();
        if (statusListener != null) {
            statusListener.statusChanged("Storing completed in " + NumberFormat.getInstance().format((double)(l3 - l) / 1000.0) + " seconds");
        }
        if (progressListener != null) {
            progressListener.processFinished();
        }
    }

    public static Object loadObjectFromFile(File file) throws PersistenceException, IOException, ResourceInstantiationException {
        return PersistenceManager.loadObjectFromUrl(file.toURI().toURL());
    }

    public static Object loadObjectFromUrl(URL uRL) throws PersistenceException, IOException, ResourceInstantiationException {
        Object object;
        exceptionOccured = false;
        ProgressListener progressListener = (ProgressListener)MainFrame.getListeners().get("gate.event.ProgressListener");
        StatusListener statusListener = (StatusListener)MainFrame.getListeners().get("gate.event.StatusListener");
        if (progressListener != null) {
            progressListener.progressChanged(0);
        }
        long l = System.currentTimeMillis();
        persistenceURL = uRL;
        boolean bl = PersistenceManager.isXmlApplicationFile(uRL);
        ObjectInputStream objectInputStream = null;
        StaxReader staxReader = null;
        XStream xStream = null;
        if (bl) {
            object = new InputStreamReader(uRL.openStream());
            try {
                XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
                Object object2 = xMLInputFactory.createXMLStreamReader(uRL.toExternalForm(), (Reader)object);
                staxReader = new StaxReader(new QNameMap(), (XMLStreamReader)object2);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new PersistenceException("Error creating reader", xMLStreamException);
            }
            xStream = new XStream((HierarchicalStreamDriver)new StaxDriver());
            xStream.setClassLoader((ClassLoader)Gate.getClassLoader());
            objectInputStream = xStream.createObjectInputStream((HierarchicalStreamReader)staxReader);
        } else {
            objectInputStream = new ObjectInputStream(uRL.openStream());
        }
        object = null;
        try {
            for (Object object2 : (Collection)PersistenceManager.getTransientRepresentation(objectInputStream.readObject())) {
                try {
                    Gate.getCreoleRegister().registerDirectories((URL)object2);
                }
                catch (GateException gateException) {
                    Err.prln("Could not reload creole directory " + ((URL)object2).toExternalForm());
                }
            }
            object = objectInputStream.readObject();
            objectInputStream.close();
            existingTransientValues.clear();
            object = PersistenceManager.getTransientRepresentation(object);
            existingTransientValues.clear();
            long l2 = System.currentTimeMillis();
            if (statusListener != null) {
                statusListener.statusChanged("Loading completed in " + NumberFormat.getInstance().format((double)(l2 - l) / 1000.0) + " seconds");
            }
            if (progressListener != null) {
                progressListener.processFinished();
            }
            if (exceptionOccured) {
                throw new PersistenceException("There were errors!\nSee messages for details...");
            }
            Object object3 = object;
            return object3;
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            if (statusListener != null) {
                statusListener.statusChanged("Loading failed!");
            }
            if (progressListener != null) {
                progressListener.processFinished();
            }
            throw resourceInstantiationException;
        }
        catch (Exception exception) {
            if (statusListener != null) {
                statusListener.statusChanged("Loading failed!");
            }
            if (progressListener != null) {
                progressListener.processFinished();
            }
            throw new PersistenceException(exception);
        }
        finally {
            persistenceURL = null;
        }
    }

    private static boolean isXmlApplicationFile(URL uRL) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        String string = bufferedReader.readLine();
        bufferedReader.close();
        for (String string2 : STARTOFXMLAPPLICATIONFILES) {
            if (string.length() < string2.length() || !string.substring(0, string2.length()).equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static Class registerPersitentEquivalent(Class clazz, Class clazz2) throws PersistenceException {
        if (!Persistence.class.isAssignableFrom(clazz2)) {
            throw new PersistenceException("Persistent equivalent types have to implement " + Persistence.class.getName() + "!\n" + clazz2.getName() + " does not!");
        }
        return persistentReplacementTypes.put(clazz, clazz2);
    }

    static {
        classComparator = new ClassComparator();
        exceptionOccured = false;
        persistentReplacementTypes = new HashMap();
        try {
            PersistenceManager.registerPersitentEquivalent(VisualResource.class, SlashDevSlashNull.class);
            PersistenceManager.registerPersitentEquivalent(URL.class, URLHolder.class);
            PersistenceManager.registerPersitentEquivalent(Map.class, MapPersistence.class);
            PersistenceManager.registerPersitentEquivalent(Collection.class, CollectionPersistence.class);
            PersistenceManager.registerPersitentEquivalent(ProcessingResource.class, PRPersistence.class);
            PersistenceManager.registerPersitentEquivalent(DataStore.class, DSPersistence.class);
            PersistenceManager.registerPersitentEquivalent(LanguageResource.class, LRPersistence.class);
            PersistenceManager.registerPersitentEquivalent(Corpus.class, CorpusPersistence.class);
            PersistenceManager.registerPersitentEquivalent(Controller.class, ControllerPersistence.class);
            PersistenceManager.registerPersitentEquivalent(ConditionalController.class, ConditionalControllerPersistence.class);
            PersistenceManager.registerPersitentEquivalent(LanguageAnalyser.class, LanguageAnalyserPersistence.class);
            PersistenceManager.registerPersitentEquivalent(SerialAnalyserController.class, SerialAnalyserControllerPersistence.class);
            PersistenceManager.registerPersitentEquivalent(JDBCDataStore.class, JDBCDSPersistence.class);
            PersistenceManager.registerPersitentEquivalent(AnalyserRunningStrategy.class, AnalyserRunningStrategyPersistence.class);
        }
        catch (PersistenceException persistenceException) {
            persistenceException.printStackTrace();
        }
        existingPersitentReplacements = new HashMap();
        existingTransientValues = new HashMap();
    }

    public static class NotComparableException
    extends RuntimeException {
        public NotComparableException(String string) {
            super(string);
        }

        public NotComparableException() {
        }
    }

    public static class ClassComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            Class clazz = (Class)object;
            Class clazz2 = (Class)object2;
            if (clazz.equals(clazz2)) {
                return 0;
            }
            if (clazz.isAssignableFrom(clazz2)) {
                return 1;
            }
            if (clazz2.isAssignableFrom(clazz)) {
                return -1;
            }
            throw new NotComparableException();
        }
    }

    public static class URLHolder
    implements Persistence {
        String urlString;
        private static final String relativePathMarker = "$relpath$";
        static final long serialVersionUID = 7943459208429026229L;

        public void extractDataFromSource(Object object) throws PersistenceException {
            try {
                URL uRL = (URL)object;
                if (uRL.getProtocol().equals("file")) {
                    try {
                        this.urlString = relativePathMarker + PersistenceManager.getRelativePath(persistenceFile.toURI().toURL(), uRL);
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.urlString = ((URL)object).toExternalForm();
                    }
                } else {
                    this.urlString = ((URL)object).toExternalForm();
                }
            }
            catch (ClassCastException classCastException) {
                throw new PersistenceException(classCastException);
            }
        }

        public Object createObject() throws PersistenceException {
            try {
                if (this.urlString.startsWith(relativePathMarker)) {
                    URL uRL = persistenceURL;
                    return new URL(uRL, this.urlString.substring(relativePathMarker.length()));
                }
                return new URL(this.urlString);
            }
            catch (MalformedURLException malformedURLException) {
                throw new PersistenceException(malformedURLException);
            }
        }
    }

    public static class SlashDevSlashNull
    implements Persistence {
        static final long serialVersionUID = -8665414981783519937L;

        public void extractDataFromSource(Object object) throws PersistenceException {
        }

        public Object createObject() throws PersistenceException, ResourceInstantiationException {
            return null;
        }
    }

    protected static class ObjectHolder {
        private Object target;

        ObjectHolder(Object object) {
            this.target = object;
        }

        public int hashCode() {
            return System.identityHashCode(this.target);
        }

        public boolean equals(Object object) {
            if (object instanceof ObjectHolder) {
                return ((ObjectHolder)object).target == this.target;
            }
            return false;
        }

        public Object getTarget() {
            return this.target;
        }
    }
}

