/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.util.Tools;
import java.lang.reflect.Constructor;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestTools
extends TestCase {
    public TestTools(String string) {
        super(string);
    }

    public void testGetMostSpecificConstructor1() throws Exception {
        Constructor constructor = ConstructorTest.class.getConstructor(InterfaceB.class);
        Constructor constructor2 = Tools.getMostSpecificConstructor(ConstructorTest.class, ClassB.class);
        TestTools.assertEquals((String)"Most specific constructor for ConstructorTest taking a ClassB should be ConstructorTest(InterfaceB)", constructor, (Object)constructor2);
    }

    public void testGetMostSpecificConstructor2() throws Exception {
        Constructor constructor = ConstructorTest.class.getConstructor(SubInterfaceB.class);
        Constructor constructor2 = Tools.getMostSpecificConstructor(ConstructorTest.class, ClassSubB.class);
        TestTools.assertEquals((String)"Most specific constructor for ConstructorTest taking a ClassSubB should be ConstructorTest(SubInterfaceB)", constructor, (Object)constructor2);
    }

    public void testGetMostSpecificConstructor3() throws Exception {
        Constructor constructor = ConstructorTest.class.getConstructor(ClassAB.class);
        Constructor constructor2 = Tools.getMostSpecificConstructor(ConstructorTest.class, SubClassOfAB.class);
        TestTools.assertEquals((String)"Most specific constructor for ConstructorTest taking a SubClassOfAB should be ConstructorTest(ClassAB)", constructor, (Object)constructor2);
    }

    public void testGetMostSpecificConstructor4() throws Exception {
        try {
            Tools.getMostSpecificConstructor(ConstructorTest.class, DifferentClassAB.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            TestTools.assertTrue((String)"Expected \"ambiguous\" exception", (boolean)noSuchMethodException.getMessage().startsWith("Ambiguous"));
            return;
        }
        TestTools.fail((String)"getMostSpecificConstructor(ConstructorTest, DifferentClassAB) should have thrown an exception");
    }

    public static Test suite() {
        return new TestSuite(TestTools.class);
    }

    public static void main(String[] stringArray) throws Exception {
        TestTools testTools = new TestTools("TestTools");
        testTools.testGetMostSpecificConstructor1();
        testTools.testGetMostSpecificConstructor2();
        testTools.testGetMostSpecificConstructor3();
        testTools.testGetMostSpecificConstructor4();
    }

    private static class ConstructorTest {
        public ConstructorTest(InterfaceA interfaceA) {
        }

        public ConstructorTest(InterfaceB interfaceB) {
        }

        public ConstructorTest(SubInterfaceB subInterfaceB) {
        }

        public ConstructorTest(ClassAB classAB) {
        }
    }

    private static class DifferentClassAB
    implements InterfaceA,
    InterfaceB {
        private DifferentClassAB() {
        }
    }

    private static class SubClassOfAB
    extends ClassAB {
        private SubClassOfAB() {
        }
    }

    private static class ClassAB
    implements InterfaceA,
    InterfaceB {
        private ClassAB() {
        }
    }

    private static class ClassSubB
    implements SubInterfaceB {
        private ClassSubB() {
        }
    }

    private static class ClassB
    implements InterfaceB {
        private ClassB() {
        }
    }

    private static class ClassA
    implements InterfaceA {
        private ClassA() {
        }
    }

    private static interface SubInterfaceB
    extends InterfaceB {
    }

    private static interface InterfaceB {
    }

    private static interface InterfaceA {
    }
}

