/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.util.RBTreeMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestRBTreeMap
extends TestCase {
    private static final boolean DEBUG = false;
    private RBTreeMap myTree;

    public TestRBTreeMap(String string) {
        super(string);
    }

    public void setUp() {
        this.myTree = new RBTreeMap();
        this.myTree.put(new Long(10L), "Ten");
        this.myTree.put(new Long(20L), "Twenty");
        this.myTree.put(new Long(30L), "Thirty");
        this.myTree.put(new Long(40L), "Forty");
        this.myTree.put(new Long(50L), "Fifty");
    }

    public void testExact() {
        Long l = new Long(10L);
        String string = "Ten";
        Object object = this.myTree.get(l);
        TestRBTreeMap.assertEquals((Object)string, (Object)object);
        l = new Long(30L);
        string = "Thirty";
        object = this.myTree.get(l);
        TestRBTreeMap.assertEquals((Object)string, (Object)object);
        l = new Long(50L);
        string = "Fifty";
        object = this.myTree.get(l);
        TestRBTreeMap.assertEquals((Object)string, (Object)object);
        l = new Long(15L);
        object = this.myTree.get(l);
        TestRBTreeMap.assertNull((Object)object);
    }

    public void testClosestMatch() {
        Long l = new Long(10L);
        Object[] objectArray = new Object[]{"Ten", "Ten"};
        Object[] objectArray2 = this.myTree.getClosestMatch(l);
        TestRBTreeMap.assertEquals((String)"TestCM 1", (Object)objectArray[0], (Object)objectArray2[0]);
        TestRBTreeMap.assertEquals((String)"TestCM 2", (Object)objectArray[1], (Object)objectArray2[1]);
        l = new Long(5L);
        objectArray = new Object[]{null, "Ten"};
        objectArray2 = this.myTree.getClosestMatch(l);
        TestRBTreeMap.assertNull((String)"TestCM 3", (Object)objectArray2[0]);
        TestRBTreeMap.assertEquals((String)"TestCM 4", (Object)objectArray[1], (Object)objectArray2[1]);
        l = new Long(15L);
        objectArray = new Object[]{"Ten", "Twenty"};
        objectArray2 = this.myTree.getClosestMatch(l);
        TestRBTreeMap.assertEquals((String)"TestCM 5", (Object)objectArray[0], (Object)objectArray2[0]);
        TestRBTreeMap.assertEquals((String)"TestCM 6", (Object)objectArray[1], (Object)objectArray2[1]);
        l = new Long(55L);
        objectArray = new Object[]{"Fifty", null};
        objectArray2 = this.myTree.getClosestMatch(l);
        TestRBTreeMap.assertEquals((String)"TestCM 7", (Object)objectArray[0], (Object)objectArray2[0]);
        TestRBTreeMap.assertNull((String)"TestCM 8", (Object)objectArray2[1]);
        this.myTree = new RBTreeMap();
        l = new Long(15L);
        objectArray = new Object[]{null, null};
        objectArray2 = this.myTree.getClosestMatch(l);
        TestRBTreeMap.assertNull((String)"TestCM 9", (Object)objectArray2[0]);
        TestRBTreeMap.assertNull((String)"TestCM 10", (Object)objectArray2[1]);
    }

    public void testGetNextOf() {
        Long l = new Long(5L);
        String string = "Ten";
        Object object = this.myTree.getNextOf(l);
        TestRBTreeMap.assertEquals((Object)string, (Object)object);
        l = new Long(20L);
        string = "Twenty";
        object = this.myTree.getNextOf(l);
        TestRBTreeMap.assertEquals((Object)string, (Object)object);
        l = new Long(15L);
        string = "Twenty";
        object = this.myTree.getNextOf(l);
        TestRBTreeMap.assertEquals((Object)string, (Object)object);
        l = new Long(55L);
        object = this.myTree.getNextOf(l);
        TestRBTreeMap.assertNull((Object)object);
        this.myTree = new RBTreeMap();
        l = new Long(15L);
        object = this.myTree.getNextOf(l);
        TestRBTreeMap.assertNull((Object)object);
    }

    public static Test suite() {
        return new TestSuite(TestRBTreeMap.class);
    }
}

