/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Gate;
import gate.util.GateException;
import gate.util.Javac;
import gate.util.Strings;
import java.lang.reflect.Method;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestJavac
extends TestCase {
    private static final boolean DEBUG = false;

    public TestJavac(String string) {
        super(string);
    }

    public void setUp() {
    }

    public static Test suite() {
        return new TestSuite(TestJavac.class);
    }

    public void testCompiler() throws Exception {
        String string = Strings.getNl();
        String string2 = "package foo.bar;" + string + "public class Outer {" + string + "//let's make an inner class " + string + " class Adder{" + string + " public int inc(int i){" + string + "   return i + 1;" + string + " }//inc(int)" + string + " }//class Adder" + string + " //let's make another inner class" + string + " class Deccer{" + string + " public int dec(int i){" + string + "   return i - 1;" + string + " }//dec(int)" + string + " }//clas Deccer" + string + " //some public methods" + string + " public int inc(int i){" + string + "   return new Adder().inc(i);" + string + " }" + string + " public int dec(int i){" + string + "   return new Deccer().dec(i);" + string + " }" + string + " }//class Outer" + string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("foo.bar.Outer", string2);
        Javac.loadClasses(hashMap);
        Class<?> clazz = Gate.getClassLoader().loadClass("foo.bar.Outer");
        TestJavac.assertNotNull((String)"Could not find decalred class", clazz);
        Object obj = clazz.newInstance();
        TestJavac.assertNotNull((String)"Could not instantiate declared class", obj);
        Method method = clazz.getDeclaredMethod("inc", Integer.TYPE);
        TestJavac.assertNotNull((String)"Could not find declared method", (Object)method);
        Object object = method.invoke(obj, new Integer(1));
        TestJavac.assertEquals((String)"Invalid result", (Object)object, (Object)new Integer(2));
        method = clazz.getDeclaredMethod("dec", Integer.TYPE);
        TestJavac.assertNotNull((String)"Could not find declared method", (Object)method);
        object = method.invoke(obj, new Integer(2));
        TestJavac.assertEquals((String)"Invalid result", (Object)object, (Object)new Integer(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompileError() throws Exception {
        System.err.println("Testing for a compile error:");
        String string = Strings.getNl();
        String string2 = "package foo.bar;" + string + "public class X {" + string + " //some public methods" + string + " public void foo(){" + string + " String nullStr = null;" + string + "// This should cause a compile error:" + string + " nullStr = 123;" + string + "} " + string + " " + string + " " + string + " }//class Outer" + string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("foo.bar.X", string2);
        boolean bl = false;
        try {
            Javac.loadClasses(hashMap);
        }
        catch (GateException gateException) {
            bl = true;
        }
        TestJavac.assertTrue((String)"Garbage java code did not raise an exception!", (boolean)bl);
    }
}

